/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.nlp;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;

public final class RomanNum {
    private static final String RESOURCE_PATH = "org/luwrain/grammar/romannum.txt";
    private final String[] values;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RomanNum() {
        URL url = this.getClass().getClassLoader().getResource(RESOURCE_PATH);
        if (url == null) {
            throw new RuntimeException("No resource org/luwrain/grammar/romannum.txt");
        }
        ArrayList<String> res = new ArrayList<String>();
        res.add("");
        try (BufferedReader r = new BufferedReader(new InputStreamReader(url.openStream()));){
            String line = r.readLine();
            while (line != null) {
                if (!line.trim().isEmpty()) {
                    res.add(line.trim());
                }
                line = r.readLine();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.values = res.toArray(new String[res.size()]);
    }

    public int find(String s) {
        if (s == null) {
            throw new NullPointerException("s can't be null");
        }
        if (s.isEmpty()) {
            throw new IllegalArgumentException("s can't be empty");
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (!this.values[i].equals(s)) continue;
            return i;
        }
        return -1;
    }

    public String get(int num) {
        if (num < 1 || num >= this.values.length) {
            throw new IllegalArgumentException("num (" + String.valueOf(num) + ") must be greater than zero and less than " + String.valueOf(this.values.length));
        }
        return this.values[num];
    }

    public String[] getAll() {
        return (String[])this.values.clone();
    }
}

