/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.nlp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.luwrain.controls.DefaultLineMarks;
import org.luwrain.core.LineMarks;
import org.luwrain.nlp.SpellChecker;
import org.luwrain.nlp.SpellExclusion;
import org.luwrain.nlp.SpellProblem;
import org.luwrain.util.RangeUtils;

public class SpellText {
    public static final String LOG_COMPONENT = "spelling";
    final SpellExclusion exclusion;
    final String text;
    final List<Fragment> fragments = new ArrayList<Fragment>();
    final List<SpellProblem> problems;

    public SpellText(String[] text, SpellChecker checker) {
        this.exclusion = checker.getExclusion();
        if (text.length == 0) {
            this.text = "";
            this.problems = Arrays.asList(new SpellProblem[0]);
            return;
        }
        if (text.length == 1) {
            this.text = text[0];
            this.fragments.add(new Fragment(0, text[0].length()));
            this.problems = this.filterExclusions(this.text, checker.check(this.text));
            return;
        }
        StringBuilder b = new StringBuilder();
        b.append(text[0]);
        this.fragments.add(new Fragment(0, b.length()));
        for (int i = 1; i < text.length; ++i) {
            this.fragments.add(new Fragment(b.length() + 1, b.length() + text[i].length() + 1));
            b.append(" ").append(text[i]);
        }
        this.text = new String(b);
        if (this.fragments.size() != text.length) {
            throw new IllegalStateException("the fragments and text arrays have different length");
        }
        this.problems = this.filterExclusions(this.text, checker.check(this.text));
    }

    public List<List<LineMarks.Mark>> buildMarks() {
        ArrayList<List<LineMarks.Mark>> res = new ArrayList<List<LineMarks.Mark>>();
        for (Fragment f : this.fragments) {
            ArrayList<DefaultLineMarks.MarkImpl> a = new ArrayList<DefaultLineMarks.MarkImpl>();
            for (SpellProblem p : this.problems) {
                int[] range = RangeUtils.commonRangeByBounds((int)p.getStart(), (int)p.getEnd(), (int)f.posFrom, (int)f.posTo);
                if (range == null) continue;
                a.add(new DefaultLineMarks.MarkImpl(LineMarks.Mark.Type.WEAK, range[0] - f.posFrom, range[1] - f.posFrom, (LineMarks.MarkObject)p));
            }
            res.add(a);
        }
        return res;
    }

    public List<Fragment> getFragments() {
        return this.fragments;
    }

    public List<SpellProblem> getProblems() {
        return this.problems;
    }

    private List<SpellProblem> filterExclusions(String text, List<SpellProblem> source) {
        if (this.exclusion == null) {
            return source;
        }
        HashSet<String> wordsToExclude = new HashSet<String>();
        for (SpellExclusion.Exclusion e : this.exclusion.getExclusions()) {
            String word = e.getText().trim();
            if (word.isEmpty()) continue;
            wordsToExclude.add(word.toUpperCase());
        }
        ArrayList<SpellProblem> res = new ArrayList<SpellProblem>();
        for (SpellProblem p : source) {
            String f = text.substring(p.getStart(), p.getEnd()).toUpperCase();
            if (wordsToExclude.contains(f)) continue;
            res.add(p);
        }
        return res;
    }

    public static final class Fragment {
        final int posFrom;
        final int posTo;

        Fragment(int posFrom, int posTo) {
            this.posFrom = posFrom;
            this.posTo = posTo;
        }
    }
}

