/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.languagetool.AnalyzedSentence;
import org.languagetool.CheckResults;
import org.languagetool.GlobalConfig;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.Range;
import org.languagetool.RuleMatchListener;
import org.languagetool.UserConfig;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.RuleSet;

public class MultiThreadedJLanguageTool
extends JLanguageTool {
    private final int threadPoolSize;
    private final ExecutorService threadPool;

    public MultiThreadedJLanguageTool(Language language) {
        this(language, null);
    }

    public MultiThreadedJLanguageTool(Language language, int threadPoolSize) {
        this(language, null, threadPoolSize, null);
    }

    public MultiThreadedJLanguageTool(Language language, Language motherTongue) {
        this(language, motherTongue, MultiThreadedJLanguageTool.getDefaultThreadCount(), null);
    }

    public MultiThreadedJLanguageTool(Language language, Language motherTongue, UserConfig userConfig) {
        this(language, motherTongue, MultiThreadedJLanguageTool.getDefaultThreadCount(), userConfig);
    }

    public MultiThreadedJLanguageTool(Language language, Language motherTongue, int threadPoolSize, UserConfig userConfig) {
        this(language, motherTongue, -1, null, userConfig);
    }

    public MultiThreadedJLanguageTool(Language language, Language motherTongue, int threadPoolSize, GlobalConfig globalConfig, UserConfig userConfig) {
        super(language, Collections.emptyList(), motherTongue, null, globalConfig, userConfig);
        this.threadPoolSize = threadPoolSize <= 0 ? MultiThreadedJLanguageTool.getDefaultThreadCount() : threadPoolSize;
        this.threadPool = new ForkJoinPool(this.threadPoolSize, ForkJoinPool.defaultForkJoinWorkerThreadFactory, null, false);
    }

    public void shutdown() {
        this.threadPool.shutdownNow();
    }

    public void shutdownWhenDone() {
        this.threadPool.shutdown();
    }

    private static int getDefaultThreadCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    protected int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    protected ExecutorService getExecutorService() {
        return this.threadPool;
    }

    @Override
    protected List<AnalyzedSentence> analyzeSentences(List<String> sentences) throws IOException {
        if (sentences.size() < 2) {
            return super.analyzeSentences(sentences);
        }
        ArrayList<AnalyzedSentence> analyzedSentences = new ArrayList<AnalyzedSentence>();
        ExecutorService executorService = this.getExecutorService();
        int j = 0;
        ArrayList<AnalyzeSentenceCallable> callables = new ArrayList<AnalyzeSentenceCallable>();
        for (String sentence : sentences) {
            AnalyzeSentenceCallable analyzeSentenceCallable = ++j < sentences.size() ? new AnalyzeSentenceCallable(sentence) : new ParagraphEndAnalyzeSentenceCallable(sentence);
            callables.add(analyzeSentenceCallable);
        }
        try {
            List futures = executorService.invokeAll(callables);
            for (Future future : futures) {
                AnalyzedSentence analyzedSentence = (AnalyzedSentence)future.get();
                this.rememberUnknownWords(analyzedSentence);
                this.printSentenceInfo(analyzedSentence);
                analyzedSentences.add(analyzedSentence);
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        return analyzedSentences;
    }

    @Override
    protected CheckResults performCheck(List<AnalyzedSentence> analyzedSentences, List<String> sentenceTexts, RuleSet ruleSet, JLanguageTool.ParagraphHandling paraMode, AnnotatedText annotatedText, RuleMatchListener listener, JLanguageTool.Mode mode, JLanguageTool.Level level, boolean checkRemoteRules) {
        List<Rule> allRules = ruleSet.allRules();
        List<JLanguageTool.SentenceData> sentences = this.computeSentenceData(analyzedSentences, sentenceTexts);
        HashMap<Rule, BitSet> map = new HashMap<Rule, BitSet>();
        for (int i = 0; i < sentences.size(); ++i) {
            for (Rule rule : ruleSet.rulesForSentence(sentences.get((int)i).analyzed)) {
                map.computeIfAbsent(rule, __ -> new BitSet()).set(i);
            }
        }
        AtomicInteger ruleIndex = new AtomicInteger();
        TreeMap ruleMatches = new TreeMap();
        ArrayList<Range> ignoreRanges = new ArrayList<Range>();
        List futures = IntStream.range(0, this.getThreadPoolSize()).mapToObj(__ -> this.getExecutorService().submit(() -> {
            int index;
            while ((index = ruleIndex.getAndIncrement()) < allRules.size()) {
                CheckResults res;
                Rule rule = (Rule)allRules.get(index);
                BitSet applicable = (BitSet)map.get(rule);
                if (applicable == null || (res = new JLanguageTool.TextCheckCallable(RuleSet.plain(Collections.singletonList(rule)), RuleSet.filterList(applicable, sentences), paraMode, annotatedText, listener, mode, level, true).call()).getRuleMatches().isEmpty()) continue;
                Object object = ruleMatches;
                synchronized (object) {
                    ruleMatches.put(index, res.getRuleMatches());
                }
                object = ignoreRanges;
                synchronized (object) {
                    ignoreRanges.addAll(res.getIgnoredRanges());
                }
            }
            return null;
        })).collect(Collectors.toList());
        try {
            for (Future future : futures) {
                future.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        List<RuleMatch> rm = this.applyCustomFilters(Lists.newArrayList((Iterable)Iterables.concat(ruleMatches.values())), annotatedText);
        return new CheckResults(rm, ignoreRanges);
    }

    private final class ParagraphEndAnalyzeSentenceCallable
    extends AnalyzeSentenceCallable {
        private ParagraphEndAnalyzeSentenceCallable(String sentence) {
            super(sentence);
        }

        @Override
        public AnalyzedSentence call() throws Exception {
            return JLanguageTool.markAsParagraphEnd(super.call());
        }
    }

    private class AnalyzeSentenceCallable
    implements Callable<AnalyzedSentence> {
        private final String sentence;

        private AnalyzeSentenceCallable(String sentence) {
            this.sentence = sentence;
        }

        @Override
        public AnalyzedSentence call() throws Exception {
            return MultiThreadedJLanguageTool.this.getAnalyzedSentence(this.sentence);
        }
    }
}

