/*
 * Decompiled with CFR 0.152.
 */
package com.github.kklisura.cdt.launch;

import com.github.kklisura.cdt.launch.ChromeArguments;
import com.github.kklisura.cdt.launch.config.ChromeLauncherConfiguration;
import com.github.kklisura.cdt.launch.exceptions.ChromeProcessException;
import com.github.kklisura.cdt.launch.exceptions.ChromeProcessTimeoutException;
import com.github.kklisura.cdt.launch.support.ProcessLauncher;
import com.github.kklisura.cdt.launch.support.annotations.ChromeArgument;
import com.github.kklisura.cdt.launch.support.impl.ProcessLauncherImpl;
import com.github.kklisura.cdt.services.ChromeService;
import com.github.kklisura.cdt.services.impl.ChromeServiceImpl;
import com.github.kklisura.cdt.utils.ChromeDevToolsUtils;
import com.github.kklisura.cdt.utils.FilesUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChromeLauncher
implements AutoCloseable {
    public static final String ENV_CHROME_PATH = "CHROME_PATH";
    private static final Logger LOGGER = LoggerFactory.getLogger(ChromeLauncher.class);
    private static final Logger CHROME_OUTPUT_LOGGER = LoggerFactory.getLogger((String)(ChromeLauncher.class.getPackage().getName() + ".chrome.output"));
    private static final String TEMP_PREFIX = "cdt-user-data-dir";
    private static final Pattern DEVTOOLS_LISTENING_LINE_PATTERN = Pattern.compile("^DevTools listening on ws:\\/\\/.+?:(\\d+)\\/");
    private static final String[] CHROME_BINARIES = new String[]{"/usr/bin/chromium", "/usr/bin/chromium-browser", "/usr/bin/google-chrome-stable", "/usr/bin/google-chrome", "/snap/bin/chromium", "/Applications/Chromium.app/Contents/MacOS/Chromium", "/Applications/Google Chrome.app/Contents/MacOS/Google Chrome", "/Applications/Google Chrome Canary.app/Contents/MacOS/Google Chrome Canary", "C:/Program Files (x86)/Google/Chrome/Application/chrome.exe", "C:/Program Files/Google/Chrome/Application/chrome.exe"};
    private Process chromeProcess;
    private Thread shutdownHookThread = new Thread(this::close);
    private ProcessLauncher processLauncher;
    private Environment environment;
    private ShutdownHookRegistry shutdownHookRegistry;
    private ChromeLauncherConfiguration configuration;
    private Path userDataDirPath;

    public ChromeLauncher() {
        this(new ChromeLauncherConfiguration());
    }

    public ChromeLauncher(ChromeLauncherConfiguration configuration) {
        this(new ProcessLauncherImpl(), System::getenv, new RuntimeShutdownHookRegistry(), configuration);
    }

    public ChromeLauncher(ProcessLauncher processLauncher, Environment environment, ShutdownHookRegistry shutdownHookRegistry, ChromeLauncherConfiguration configuration) {
        this.processLauncher = processLauncher;
        this.environment = environment;
        this.shutdownHookRegistry = shutdownHookRegistry;
        this.configuration = configuration;
    }

    public ChromeService launch(Path chromeBinaryPath, ChromeArguments chromeArguments) throws ChromeProcessException {
        int port = this.launchChromeProcess(chromeBinaryPath, chromeArguments);
        return new ChromeServiceImpl(port);
    }

    public ChromeService launch(ChromeArguments chromeArguments) throws ChromeProcessException {
        return this.launch(this.getChromeBinaryPath(), chromeArguments);
    }

    public ChromeService launch(boolean headless) throws ChromeProcessException {
        return this.launch(this.getChromeBinaryPath(), ChromeArguments.defaults(headless).build());
    }

    public ChromeService launch() throws ChromeProcessException {
        return this.launch(true);
    }

    public Path getChromeBinaryPath() {
        String envChrome = this.environment.getEnv(ENV_CHROME_PATH);
        if (envChrome != null) {
            boolean isExecutable = this.processLauncher.isExecutable(envChrome);
            if (isExecutable) {
                return Paths.get(envChrome, new String[0]).toAbsolutePath();
            }
            throw new RuntimeException("CHROME_PATH environment value is not an executable file.");
        }
        for (String binary : CHROME_BINARIES) {
            boolean isExecutable = this.processLauncher.isExecutable(binary);
            if (!isExecutable) continue;
            return Paths.get(binary, new String[0]).toAbsolutePath();
        }
        throw new RuntimeException("Could not find chrome binary! Try setting CHROME_PATH env to chrome binary path.");
    }

    @Override
    public void close() {
        if (this.chromeProcess != null && this.chromeProcess.isAlive()) {
            LOGGER.info("Closing chrome process...");
            this.chromeProcess.destroy();
            try {
                if (!this.chromeProcess.waitFor(this.configuration.getShutdownWaitTime(), TimeUnit.SECONDS)) {
                    this.chromeProcess.destroyForcibly();
                    this.chromeProcess.waitFor(this.configuration.getShutdownWaitTime(), TimeUnit.SECONDS);
                }
                LOGGER.info("Chrome process closed.");
            }
            catch (InterruptedException e) {
                LOGGER.error("Interrupted while waiting for chrome process to shutdown.", (Throwable)e);
                this.chromeProcess.destroyForcibly();
            }
            finally {
                FilesUtils.deleteQuietly(this.userDataDirPath);
            }
            try {
                this.shutdownHookRegistry.remove(this.shutdownHookThread);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public int exitValue() {
        if (this.chromeProcess == null) {
            throw new IllegalStateException("Chrome process has not been started started.");
        }
        return this.chromeProcess.exitValue();
    }

    public boolean isAlive() {
        return this.chromeProcess != null && this.chromeProcess.isAlive();
    }

    private int launchChromeProcess(Path chromeBinary, ChromeArguments chromeArguments) throws ChromeProcessException {
        if (this.isAlive()) {
            throw new IllegalStateException("Chrome process has already been started started.");
        }
        this.shutdownHookRegistry.register(this.shutdownHookThread);
        Map<String, Object> argumentsMap = this.getArguments(chromeArguments);
        if (chromeArguments.getUserDataDir() == null) {
            String userDatDir = FilesUtils.randomTempDir(TEMP_PREFIX);
            this.userDataDirPath = Paths.get(userDatDir, new String[0]);
            argumentsMap.put("user-data-dir", userDatDir);
        }
        List<String> arguments = this.argsMapToArgsList(argumentsMap);
        LOGGER.info("Launching chrome process {} with arguments {}", (Object)chromeBinary.toString(), argumentsMap);
        try {
            this.chromeProcess = this.processLauncher.launch(chromeBinary.toString(), arguments);
            return this.waitForDevToolsServer(this.chromeProcess);
        }
        catch (IOException e) {
            this.shutdownHookRegistry.remove(this.shutdownHookThread);
            throw new ChromeProcessException("Failed starting chrome process.", e);
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    private int waitForDevToolsServer(Process process) throws ChromeProcessTimeoutException {
        CompletableFuture port = new CompletableFuture();
        AtomicReference<String> chromeOutput = new AtomicReference<String>("");
        Thread readLineThread = new Thread(() -> {
            StringBuilder chromeOutputBuilder = new StringBuilder();
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                while ((line = reader.readLine()) != null) {
                    CHROME_OUTPUT_LOGGER.debug(line);
                    if (port.isDone()) continue;
                    Matcher matcher = DEVTOOLS_LISTENING_LINE_PATTERN.matcher(line);
                    if (matcher.find()) {
                        port.complete(Integer.parseInt(matcher.group(1)));
                        if (!CHROME_OUTPUT_LOGGER.isDebugEnabled()) break;
                        chromeOutputBuilder = null;
                        chromeOutput.set(null);
                        continue;
                    }
                    if (chromeOutputBuilder.length() != 0) {
                        chromeOutputBuilder.append(System.lineSeparator());
                    }
                    chromeOutputBuilder.append(line);
                    chromeOutput.set(chromeOutputBuilder.toString());
                }
            }
            catch (Exception e) {
                block8: {
                    try {
                        if (port.isDone()) {
                            LOGGER.debug("Error while reading Chrome process output.", (Throwable)e);
                            break block8;
                        }
                        LOGGER.error("Failed while waiting for dev tools server.", (Throwable)e);
                        port.completeExceptionally(e);
                    }
                    catch (Throwable throwable) {
                        ChromeDevToolsUtils.closeQuietly(reader);
                        throw throwable;
                    }
                }
                ChromeDevToolsUtils.closeQuietly(reader);
            }
            ChromeDevToolsUtils.closeQuietly(reader);
        });
        readLineThread.setName("chrome-launcher:read-line-thread");
        readLineThread.start();
        try {
            return (Integer)port.get(this.configuration.getStartupWaitTime(), TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            this.close(readLineThread);
            throw new ChromeProcessTimeoutException("Failed while waiting for chrome to start: Timeout expired! Chrome output: " + chromeOutput.get());
        }
        catch (InterruptedException e) {
            this.close(readLineThread);
            LOGGER.error("Interrupted while waiting for dev tools server.", (Throwable)e);
            throw new RuntimeException("Interrupted while waiting for dev tools server.", e);
        }
        catch (ExecutionException e) {
            this.close(readLineThread);
            throw new RuntimeException("Failed while waiting for dev tools server.", e);
        }
    }

    private void close(Thread thread) {
        try {
            thread.join(TimeUnit.SECONDS.toMillis(this.configuration.getThreadWaitTime()));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private List<String> argsMapToArgsList(Map<String, Object> args) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, Object> entry : args.entrySet()) {
            if (entry.getValue() == null || Boolean.FALSE.equals(entry.getValue())) continue;
            if (Boolean.TRUE.equals(entry.getValue())) {
                result.add("--" + entry.getKey());
                continue;
            }
            result.add("--" + entry.getKey() + "=" + entry.getValue());
        }
        return result;
    }

    private Map<String, Object> getArguments(ChromeArguments arguments) {
        Field[] chromeArgumentsFields;
        HashMap<String, Object> args = new HashMap<String, Object>(arguments.getAdditionalArguments());
        for (Field field : chromeArgumentsFields = ChromeArguments.class.getDeclaredFields()) {
            ChromeArgument fieldAnnotation = field.getAnnotation(ChromeArgument.class);
            if (fieldAnnotation == null) continue;
            try {
                field.setAccessible(true);
                Object fieldValue = field.get(arguments);
                if (fieldValue == null) continue;
                args.putIfAbsent(fieldAnnotation.value(), fieldValue);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return args;
    }

    public static class RuntimeShutdownHookRegistry
    implements ShutdownHookRegistry {
    }

    public static interface ShutdownHookRegistry {
        default public void register(Thread thread) {
            Runtime.getRuntime().addShutdownHook(thread);
        }

        default public void remove(Thread thread) {
            Runtime.getRuntime().removeShutdownHook(thread);
        }
    }

    @FunctionalInterface
    public static interface Environment {
        public String getEnv(String var1);
    }
}

