/*
 * Decompiled with CFR 0.152.
 */
package com.github.kklisura.cdt.services.invocation;

import com.github.kklisura.cdt.protocol.support.annotations.EventName;
import com.github.kklisura.cdt.protocol.support.annotations.ParamName;
import com.github.kklisura.cdt.protocol.support.annotations.ReturnTypeParameter;
import com.github.kklisura.cdt.protocol.support.annotations.Returns;
import com.github.kklisura.cdt.protocol.support.types.EventHandler;
import com.github.kklisura.cdt.protocol.support.types.EventListener;
import com.github.kklisura.cdt.services.ChromeDevToolsService;
import com.github.kklisura.cdt.services.types.MethodInvocation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;

public class CommandInvocationHandler
implements InvocationHandler {
    private static final String EVENT_LISTENER_PREFIX = "on";
    private static final AtomicLong ID_SUPPLIER = new AtomicLong(1L);
    private ChromeDevToolsService chromeDevToolsService;

    public void setChromeDevToolsService(ChromeDevToolsService chromeDevToolsService) {
        this.chromeDevToolsService = chromeDevToolsService;
    }

    @Override
    public Object invoke(Object unused, Method method, Object[] args) throws Throwable {
        if (CommandInvocationHandler.isEventSubscription(method)) {
            String domainName = method.getDeclaringClass().getSimpleName();
            String eventName = CommandInvocationHandler.getEventName(method);
            Class<?> eventHandlerType = CommandInvocationHandler.getEventHandlerType(method);
            return this.chromeDevToolsService.addEventListener(domainName, eventName, (EventHandler)args[0], eventHandlerType);
        }
        Class<?> returnType = method.getReturnType();
        Class<?>[] returnTypeClasses = null;
        ReturnTypeParameter returnTypeParameter = method.getAnnotation(ReturnTypeParameter.class);
        if (returnTypeParameter != null) {
            returnTypeClasses = returnTypeParameter.value();
        }
        String returnProperty = null;
        Returns returnsAnnotation = method.getAnnotation(Returns.class);
        if (returnsAnnotation != null) {
            returnProperty = returnsAnnotation.value();
        }
        MethodInvocation methodInvocation = this.createMethodInvocation(method, args);
        return this.chromeDevToolsService.invoke(returnProperty, returnType, returnTypeClasses, methodInvocation);
    }

    private MethodInvocation createMethodInvocation(Method method, Object[] args) {
        String domainName = method.getDeclaringClass().getSimpleName();
        String methodName = method.getName();
        MethodInvocation methodInvocation = new MethodInvocation();
        methodInvocation.setId(ID_SUPPLIER.getAndIncrement());
        methodInvocation.setMethod(domainName + "." + methodName);
        methodInvocation.setParams(this.buildMethodParams(method, args));
        return methodInvocation;
    }

    private Map<String, Object> buildMethodParams(Method method, Object[] args) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        Parameter[] parameters = method.getParameters();
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                params.put(parameters[i].getAnnotation(ParamName.class).value(), args[i]);
            }
        }
        return params;
    }

    private static String getEventName(Method method) {
        return method.getAnnotation(EventName.class).value();
    }

    private static Class<?> getEventHandlerType(Method method) {
        return (Class)((ParameterizedType)method.getGenericParameterTypes()[0]).getActualTypeArguments()[0];
    }

    public static boolean isEventSubscription(Method method) {
        String name = method.getName();
        Parameter[] parameters = method.getParameters();
        return name.startsWith(EVENT_LISTENER_PREFIX) && EventListener.class.equals(method.getReturnType()) && parameters != null && parameters.length == 1 && EventHandler.class.isAssignableFrom(parameters[0].getType());
    }
}

