/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.inlandes;

import org.luwrain.inlandes.Token;

public final class ReplacementToken
implements Token {
    final Token[] sourceTokens;
    public final int sourceRangeFrom;
    public final int sourceRangeTo;
    public final Token token;

    public ReplacementToken(Token[] sourceTokens, int sourceRangeFrom, int sourceRangeTo, Token token) {
        if (sourceTokens == null) {
            throw new NullPointerException("sourceTokens can't be null");
        }
        if (sourceRangeFrom < 0) {
            throw new IllegalArgumentException("sourceRangeFrom can't be negative");
        }
        if (sourceRangeTo < 0) {
            throw new IllegalArgumentException("sourceRangeTo can't be negative");
        }
        if (sourceRangeFrom > sourceRangeTo) {
            throw new IllegalArgumentException("sourceRangeFrom must be less or equal than sourceRangeTo");
        }
        if (token == null) {
            throw new NullPointerException("token can't be null");
        }
        this.sourceTokens = (Token[])sourceTokens.clone();
        this.sourceRangeFrom = sourceRangeFrom;
        this.sourceRangeTo = sourceRangeTo;
        this.token = token;
    }

    @Override
    public boolean isLatin() {
        return this.token.isLatin();
    }

    @Override
    public boolean isCyril() {
        return this.token.isCyril();
    }

    @Override
    public boolean isNum() {
        return this.token.isNum();
    }

    @Override
    public boolean isPunc() {
        return this.token.isPunc();
    }

    @Override
    public boolean isSpace() {
        return this.token.isSpace();
    }

    @Override
    public String getText() {
        return this.token.getText();
    }

    public String toString() {
        return this.token.toString();
    }

    public String getSourceText() {
        StringBuilder b = new StringBuilder();
        for (int i = this.sourceRangeFrom; i < this.sourceRangeTo; ++i) {
            if (this.sourceTokens[i] instanceof ReplacementToken) {
                ReplacementToken r = (ReplacementToken)this.sourceTokens[i];
                b.append(r.getSourceText());
                continue;
            }
            b.append(this.sourceTokens[i].getText());
        }
        return new String(b);
    }
}

