/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.inlandes.operations;

import org.luwrain.inlandes.Matcher;
import org.luwrain.inlandes.Operation;
import org.luwrain.inlandes.Ref;
import org.luwrain.inlandes.ReplacementToken;
import org.luwrain.inlandes.ScriptEngine;
import org.luwrain.inlandes.Token;
import org.luwrain.inlandes.operations.ScriptObjectToken;
import org.luwrain.inlandes.operations.TextToken;

public final class Assignment
extends Operation {
    public final Ref ref;
    public final ValueType valueType;
    public final String value;

    public Assignment(Ref ref, ValueType valueType, String value) {
        if (ref == null) {
            throw new NullPointerException("ref can't be null");
        }
        if (valueType == null) {
            throw new NullPointerException("valueType can't be null");
        }
        if (value == null) {
            throw new NullPointerException("value can't be null");
        }
        this.ref = ref;
        this.valueType = valueType;
        this.value = value;
    }

    private Token exec(Token[] tokens, Matcher.Matching matching, ScriptEngine scriptEngine) {
        switch (this.valueType) {
            case STRING: {
                return new TextToken(this.value);
            }
            case JS: {
                return new ScriptObjectToken(scriptEngine.eval(this.value, scriptEngine.createBindings(tokens, matching)));
            }
        }
        return null;
    }

    @Override
    public Execution getExecution(Token[] tokens, Matcher.Matching matching) {
        return new Execution(tokens, matching);
    }

    public static enum ValueType {
        STRING,
        JS;

    }

    public final class Execution
    extends Operation.Execution {
        Execution(Token[] tokens, Matcher.Matching matching) {
            super(tokens, matching, matching.getRefBegin(Assignment.this.ref.num), matching.getRefEnd(Assignment.this.ref.num));
        }

        @Override
        public Token exec(ScriptEngine scriptEngine) {
            return new ReplacementToken(this.tokens, this.rangeFrom, this.rangeTo, Assignment.this.exec(this.tokens, this.matching, scriptEngine));
        }
    }
}

