/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.studio;

import java.io.File;
import org.luwrain.app.studio.App;
import org.luwrain.app.studio.Strings;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Popup;
import org.luwrain.popups.Popups;
import org.luwrain.popups.YesNoPopup;

class Conv {
    private final Luwrain luwrain;
    private final Strings strings;

    Conv(App app) {
        NullCheck.notNull((Object)((Object)app), (String)"app");
        this.luwrain = app.getLuwrain();
        this.strings = (Strings)app.getStrings();
    }

    File newProjectDir() {
        return Popups.existingDir((Luwrain)this.luwrain, (String)"\u041a\u0430\u0442\u0430\u043b\u043e\u0433 \u043d\u043e\u0432\u043e\u0433\u043e \u043f\u0440\u043e\u0435\u043a\u0442\u0430:");
    }

    File openProject() {
        return Popups.existingFile((Luwrain)this.luwrain, (String)this.strings.openProjectPopupPrefix());
    }

    SavingType unsavedChanges() {
        YesNoPopup popup = new YesNoPopup(this.luwrain, "\u041d\u0435\u0441\u043e\u0445\u0440\u0430\u043d\u0451\u043d\u043d\u044b\u0435 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f", "\u0412\u044b \u0445\u043e\u0442\u0438\u0442\u0435 \u0441\u043e\u0445\u0440\u0430\u043d\u0438\u0442\u044c \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u044f?", true, Popups.DEFAULT_POPUP_FLAGS);
        this.luwrain.popup((Popup)popup);
        if (popup.wasCancelled()) {
            return SavingType.CANCEL;
        }
        return popup.result() ? SavingType.SAVE : SavingType.NOT_SAVE;
    }

    static enum SavingType {
        SAVE,
        NOT_SAVE,
        CANCEL;

    }
}

