/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.studio;

import java.io.File;
import java.util.Set;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.studio.App;
import org.luwrain.app.studio.Strings;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.core.Area;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Luwrain;
import org.luwrain.studio.ProjectFactory;
import org.luwrain.studio.ProjectType;

final class NewProjectLayout
extends LayoutBase
implements ListArea.ClickHandler<ProjectType> {
    private final App app;
    private final ListArea newProjectArea;

    NewProjectLayout(final App app) {
        super((AppBase)app);
        this.app = app;
        ListArea.Params params = new ListArea.Params();
        params.context = this.getControlContext();
        params.model = new ListUtils.FixedModel((Object[])new ProjectFactory(app.ide, (Strings)app.getStrings()).getNewProjectTypes());
        params.appearance = new ListUtils.DefaultAppearance<ProjectType>(params.context){

            public void announceItem(ProjectType item, Set<ListArea.Appearance.Flags> flags) {
                app.setEventResponse(DefaultEventResponse.listItem((String)app.getLuwrain().getSpeakableText(item.toString(), Luwrain.SpeakableTextType.NATURAL)));
            }
        };
        params.clickHandler = this;
        params.name = ((Strings)app.getStrings()).newProjectAreaName();
        this.newProjectArea = new ListArea(params);
        this.setAreaLayout((Area)this.newProjectArea, this.actions(new LayoutBase.ActionInfo[0]));
    }

    public boolean onListClick(ListArea listArea, int index, ProjectType projType) {
        File destDir = new File("/x/proj");
        if (destDir == null) {
            return true;
        }
        ProjectFactory factory = new ProjectFactory(this.app.ide, (Strings)this.app.getStrings());
        factory.create(projType.getId(), destDir);
        return true;
    }
}

