/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.studio.edit.java;

import java.io.File;
import java.io.IOException;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;
import org.luwrain.studio.Part;
import org.luwrain.studio.Project;
import org.luwrain.studio.edit.java.Editing;
import org.luwrain.util.FileUtils;

final class SourceFile
implements Part {
    private static final String LOG_COMPONENT = "studio";
    private final Project proj;
    private final File file;
    private String[] lines = new String[0];

    SourceFile(Project proj, File file) {
        NullCheck.notNull((Object)proj, (String)"proj");
        NullCheck.notNull((Object)file, (String)"file");
        this.proj = proj;
        this.file = file;
    }

    void update() {
        try {
            this.lines = FileUtils.readTextFileMultipleStrings((File)this.file, (String)"UTF-8", null);
            long timeStart = System.currentTimeMillis();
            long timeEnd = System.currentTimeMillis();
            long mem = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 0x100000L;
            Log.debug((String)LOG_COMPONENT, (String)("time " + (timeEnd - timeStart) + "ms, mem " + mem + "M, file " + this.file.getAbsolutePath()));
            this.lines = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getTitle() {
        return this.file.getName();
    }

    @Override
    public Part[] getChildParts() {
        return new Part[0];
    }

    @Override
    public Editing startEditing() throws IOException {
        return new Editing(this.file);
    }

    public String toString() {
        return this.getTitle();
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof SourceFile)) {
            return false;
        }
        SourceFile f = (SourceFile)o;
        return this.file.equals(f.file);
    }

    @Override
    public Part.Action[] getActions() {
        return new Part.Action[0];
    }
}

