/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.studio.edit.tex;

import java.io.File;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.core.NullCheck;
import org.luwrain.studio.Editing;
import org.luwrain.studio.IDE;
import org.luwrain.studio.Part;
import org.luwrain.studio.edit.tex.TexEditing;
import org.luwrain.studio.edit.tex.TexSourceFile;

public final class Place
implements Part {
    private static final Logger log = LogManager.getLogger();
    final IDE ide;
    final String name;
    final TexSourceFile sourceFile;
    final int x;
    final int y;

    Place(IDE ide, String name, TexSourceFile sourceFile, int x, int y) {
        NullCheck.notNull((Object)ide, (String)"ide");
        NullCheck.notNull((Object)name, (String)"name");
        NullCheck.notNull((Object)sourceFile, (String)"sourceFile");
        this.ide = ide;
        this.name = name;
        this.sourceFile = sourceFile;
        this.x = x;
        this.y = y;
    }

    @Override
    public Part[] getChildParts() {
        return null;
    }

    @Override
    public Editing startEditing() throws IOException {
        File file = this.sourceFile.getFile();
        log.trace("Opening for editing the tex file " + file.getAbsolutePath() + " at position " + this.x + "," + this.y);
        return new TexEditing(this.ide, this.sourceFile, this.x, this.y);
    }

    @Override
    public String getTitle() {
        return this.name;
    }

    public String toString() {
        return this.getTitle();
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof Place) {
            Place p = (Place)o;
            return this.sourceFile.equals(p.sourceFile) && this.name.equals(p.name) && this.x == p.x && this.y == p.y;
        }
        return false;
    }

    @Override
    public Part.Action[] getActions() {
        return new Part.Action[0];
    }
}

