/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.studio.proj.main;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import org.luwrain.core.NullCheck;
import org.luwrain.studio.IDE;
import org.luwrain.studio.Part;
import org.luwrain.studio.Project;
import org.luwrain.studio.proj.main.Folder;

public final class ProjectImpl
implements Project {
    static final Gson gson = new Gson();
    private String projName = null;
    private Folder folders = null;
    private transient File projFile = null;
    private transient File projDir = null;
    private transient IDE ide = null;

    @Override
    public Part getPartsRoot() {
        return this.folders;
    }

    @Override
    public Part getMainSourceFile() {
        return null;
    }

    @Override
    public void close() {
        this.save();
    }

    public void setProjectFile(File projFile) {
        File parent = projFile.getParentFile();
        if (parent == null) {
            throw new IllegalArgumentException("projFile must have the non-null parent");
        }
        this.projDir = parent;
        this.projFile = projFile;
    }

    @Override
    public File getProjectDir() {
        if (this.projDir == null) {
            throw new RuntimeException("The project doesn't have any information about its project directory");
        }
        return this.projDir;
    }

    private void finalizeLoading(IDE ide) {
        NullCheck.notNull((Object)ide, (String)"ide");
        if (this.folders == null) {
            this.folders = new Folder();
            this.folders.setName("Tex root");
        }
        this.folders.init(this, ide);
    }

    public String getProjName() {
        return this.projName != null ? this.projName.trim() : "";
    }

    public void setProjName(String projName) {
        NullCheck.notNull((Object)projName, (String)"projName");
        if (projName.trim().isEmpty()) {
            throw new IllegalArgumentException("projName can't be empty");
        }
        this.projName = projName.trim();
    }

    public Folder getRootFolder() {
        return this.folders;
    }

    public void setRootFolder(Folder rootFolder) {
        NullCheck.notNull((Object)rootFolder, (String)"rootFolder");
        this.folders = rootFolder;
    }

    public void save() {
        if (this.projFile == null) {
            throw new IllegalStateException("projFile is not set");
        }
        try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.projFile), "UTF-8"));){
            gson.toJson((Object)this, (Appendable)w);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Project load(File projFile, IDE ide) throws IOException {
        Gson gson = new Gson();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(projFile), "UTF-8"));){
            ProjectImpl proj = (ProjectImpl)gson.fromJson((Reader)reader, ProjectImpl.class);
            proj.setProjectFile(projFile);
            proj.finalizeLoading(ide);
            ProjectImpl projectImpl = proj;
            return projectImpl;
        }
    }
}

