/*
 * Decompiled with CFR 0.152.
 */
package uk.co.jemos.podam.typeManufacturers;

import java.lang.reflect.Type;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import uk.co.jemos.podam.api.AttributeMetadata;
import uk.co.jemos.podam.api.DataProviderStrategy;
import uk.co.jemos.podam.api.PodamUtils;
import uk.co.jemos.podam.common.PodamFloatValue;
import uk.co.jemos.podam.typeManufacturers.AbstractTypeManufacturer;

public class FloatTypeManufacturerImpl
extends AbstractTypeManufacturer<Float> {
    @Override
    public Float getType(DataProviderStrategy strategy, AttributeMetadata attributeMetadata, Map<String, Type> genericTypesArgumentsMap) {
        Float retValue;
        PodamFloatValue annotationStrategy = this.findElementOfType(attributeMetadata.getAttributeAnnotations(), PodamFloatValue.class);
        if (null != annotationStrategy) {
            String numValueStr = annotationStrategy.numValue();
            if (StringUtils.isNotEmpty((CharSequence)numValueStr)) {
                try {
                    retValue = Float.valueOf(numValueStr);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("The annotation value: " + numValueStr + " could not be converted to a Float. An exception will be thrown.", nfe);
                }
            } else {
                float maxValue;
                float minValue = annotationStrategy.minValue();
                if (minValue > (maxValue = annotationStrategy.maxValue())) {
                    maxValue = minValue;
                }
                retValue = this.getFloatInRange(minValue, maxValue, attributeMetadata);
            }
        } else {
            retValue = this.getFloat(attributeMetadata);
        }
        return retValue;
    }

    public Float getFloat(AttributeMetadata attributeMetadata) {
        return Float.valueOf((float)this.getDouble());
    }

    public Float getFloatInRange(float minValue, float maxValue, AttributeMetadata attributeMetadata) {
        return Float.valueOf((float)PodamUtils.getDoubleInRange(minValue, maxValue));
    }
}

