/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.gpt;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.app.base.AppBase;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.base.TaskCancelling;
import org.luwrain.app.gpt.App;
import org.luwrain.app.gpt.Entry;
import org.luwrain.app.gpt.Strings;
import org.luwrain.app.gpt.layouts.OptionsLayout;
import org.luwrain.controls.ConsoleArea;
import org.luwrain.controls.console.ListModel;
import org.luwrain.core.Area;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Luwrain;
import org.luwrain.core.Sounds;
import org.luwrain.io.api.yandex_gpt.CompletionOptions;
import org.luwrain.io.api.yandex_gpt.Message;
import org.luwrain.io.api.yandex_gpt.Response;
import org.luwrain.io.api.yandex_gpt.ResultAlternative;
import org.luwrain.io.api.yandex_gpt.ResultMessage;
import org.luwrain.io.api.yandex_gpt.YandexGpt;
import org.luwrain.util.FileUtils;

final class MainLayout
extends LayoutBase
implements ConsoleArea.ClickHandler<Entry>,
ConsoleArea.Appearance<Entry>,
ConsoleArea.InputHandler {
    private static final Logger log = LogManager.getLogger();
    final List<Entry> entries = new ArrayList<Entry>();
    final ConsoleArea<Entry> area;
    private final App app;

    MainLayout(App app) {
        super((AppBase)app);
        this.app = app;
        this.area = new ConsoleArea(this.consoleParams(p -> {
            p.name = ((Strings)app.getStrings()).appName();
            p.model = new ListModel(this.entries);
            p.appearance = this;
            p.inputHandler = this;
            p.clickHandler = this;
            p.inputPos = ConsoleArea.InputPos.TOP;
            p.inputPrefix = ((Strings)app.getStrings()).inputPrefix();
        }));
        this.setPropertiesHandler((Area)this.area, a -> new OptionsLayout(app, this.getReturnAction()));
        this.setAreaLayout((Area)this.area, null);
    }

    public ConsoleArea.InputHandler.Result onConsoleInput(ConsoleArea area, String text) {
        if (text.endsWith("...")) {
            this.entries.add(new Entry(Entry.Type.USER, text.substring(0, text.length() - 3).trim(), null));
            return ConsoleArea.InputHandler.Result.CLEAR_INPUT;
        }
        if (text.startsWith("f ")) {
            this.entries.add(new Entry(Entry.Type.FILE, null, text.substring(2).trim()));
            return ConsoleArea.InputHandler.Result.CLEAR_INPUT;
        }
        this.entries.add(new Entry(Entry.Type.USER, text.trim(), null));
        try {
            for (Entry e2 : this.entries) {
                if (e2.getType() != Entry.Type.FILE) continue;
                e2.setText(FileUtils.readTextFileAsString((File)new File(e2.getPath()), (String)"UTF-8"));
            }
        }
        catch (IOException ex) {
            log.error((Object)ex);
            this.app.crash(ex);
            return ConsoleArea.InputHandler.Result.OK;
        }
        List<Message> messages = this.entries.stream().map(e -> new Message(switch (e.getType()) {
            case Entry.Type.USER, Entry.Type.FILE -> "user";
            case Entry.Type.MODEL -> "assistant";
            default -> throw new IllegalArgumentException("Unknown entry type: " + e.getType().toString());
        }, e.getText())).toList();
        YandexGpt g = new YandexGpt(this.app.yandexConf.getFoundationModelsFolderId(), this.app.yandexConf.getFoundationModelsApiKey(), new CompletionOptions(false, 0.7, 4096), messages);
        TaskCancelling.TaskId taskId = this.app.newTaskId();
        this.app.runTask(taskId, () -> {
            Response resp = g.doSync();
            List a = resp.getResult().getAlternatives();
            ResultMessage m = ((ResultAlternative)a.get(0)).getMessage();
            this.app.finishedTask(taskId, () -> {
                this.entries.add(new Entry(Entry.Type.MODEL, m.getText(), null));
                area.refresh();
                this.app.setEventResponse(DefaultEventResponse.text((Sounds)Sounds.DONE, (String)m.getText()));
            });
        });
        return ConsoleArea.InputHandler.Result.CLEAR_INPUT;
    }

    public void announceItem(Entry entry) {
        switch (entry.getType()) {
            case USER: 
            case MODEL: {
                this.app.setEventResponse(DefaultEventResponse.listItem((String)this.app.getLuwrain().getSpeakableText(entry.getText(), Luwrain.SpeakableTextType.NATURAL)));
                break;
            }
            case FILE: {
                this.app.setEventResponse(DefaultEventResponse.listItem((String)(((Strings)this.app.getStrings()).filePrefix() + " " + this.app.getLuwrain().getSpeakableText(entry.getPath(), Luwrain.SpeakableTextType.PROGRAMMING))));
            }
        }
    }

    public String getTextAppearance(Entry entry) {
        switch (entry.getType()) {
            case USER: 
            case MODEL: {
                return entry.getText();
            }
            case FILE: {
                return entry.getPath();
            }
        }
        return entry.toString();
    }

    public boolean onConsoleClick(ConsoleArea area, int index, Entry entry) {
        return true;
    }
}

