/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.cpanel;

import java.util.HashMap;
import java.util.Map;
import org.luwrain.app.cpanel.SectionsTreeModelSource;
import org.luwrain.app.cpanel.TreeItem;
import org.luwrain.controls.CachedTreeModel;
import org.luwrain.controls.TreeArea;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.cpanel.Element;
import org.luwrain.cpanel.Factory;
import org.luwrain.settings.StandardFactory;

class Base {
    private final Luwrain luwrain;
    private final Factory[] factories;
    private final StandardFactory standardFactory;
    private HashMap<Element, TreeItem> treeItems = new HashMap();
    private SectionsTreeModelSource treeModelSource;
    private CachedTreeModel treeModel;

    Base(Luwrain luwrain, Factory[] factories) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNullItems((Object[])factories, (String)"factories");
        this.luwrain = luwrain;
        this.standardFactory = new StandardFactory(luwrain);
        this.factories = factories;
        this.treeModelSource = new SectionsTreeModelSource(this, this.treeItems);
        this.treeModel = new CachedTreeModel(this.treeModelSource);
        this.refreshTreeItems();
    }

    void refreshTreeItems() {
        HashMap<Element, TreeItem> newItems = new HashMap<Element, TreeItem>();
        for (Element e : this.standardFactory.getElements()) {
            Element parent;
            if (!newItems.containsKey(e)) {
                newItems.put(e, new TreeItem(e, this.standardFactory));
            }
            if ((parent = e.getParentElement()) == null) continue;
            if (!newItems.containsKey(parent)) {
                TreeItem item = new TreeItem(parent, this.standardFactory);
                item.children.add(e);
                newItems.put(parent, item);
                continue;
            }
            ((TreeItem)newItems.get((Object)parent)).children.add(e);
        }
        for (Factory f : this.factories) {
            Element[] elements;
            for (Element e : elements = f.getElements()) {
                if (e == null) {
                    Log.warning("cpanel", "control panel factory " + f.getClass().getName() + " provided a null element");
                    continue;
                }
                Element parent = e.getParentElement();
                if (parent == null) {
                    Log.warning("cpanel", "control panel element " + e.getClass().getName() + " has null parent");
                    continue;
                }
                if (!newItems.containsKey(parent)) {
                    TreeItem item = new TreeItem(parent, f);
                    item.children.add(e);
                    newItems.put(parent, item);
                } else {
                    ((TreeItem)newItems.get((Object)parent)).children.add(e);
                }
                if (newItems.containsKey(e)) continue;
                newItems.put(e, new TreeItem(e, f));
            }
        }
        for (Map.Entry entry : newItems.entrySet()) {
            TreeItem item = this.treeItems.get(entry.getKey());
            if (item == null || item.sect == null) continue;
            ((TreeItem)entry.getValue()).sect = item.sect;
        }
        this.treeItems = newItems;
        this.treeModelSource.setTreeItems(this.treeItems);
    }

    void addOnDemandElements(TreeItem treeItem) {
        Element[] toAdd;
        NullCheck.notNull((Object)treeItem, (String)"treeItem");
        if (treeItem.onDemandFilled) {
            return;
        }
        for (Element e : toAdd = treeItem.factory.getOnDemandElements(treeItem.el)) {
            if (!e.getParentElement().equals(treeItem.el)) continue;
            if (!this.treeItems.containsKey(e)) {
                this.treeItems.put(e, new TreeItem(e, treeItem.factory));
            }
            treeItem.children.add(e);
        }
        treeItem.onDemandFilled = true;
    }

    TreeArea.Model getTreeModel() {
        return this.treeModel;
    }
}

