/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.app.jobs;

import java.util.Set;
import org.luwrain.app.base.LayoutBase;
import org.luwrain.app.jobs.App;
import org.luwrain.app.jobs.Strings;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Job;
import org.luwrain.core.JobsManager;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.InputEvent;

final class MainLayout
extends LayoutBase {
    private final App app;
    final ListArea<JobsManager.Entry> jobsArea;

    MainLayout(final App app) {
        super(app);
        this.app = app;
        this.jobsArea = new ListArea(this.listParams(p -> {
            p.name = ((Strings)app.getStrings()).appName();
            p.model = new ListUtils.ListModel<JobsManager.Entry>(app.jobs.entries);
            p.appearance = new ListUtils.AbstractAppearance<JobsManager.Entry>(){

                @Override
                public void announceItem(JobsManager.Entry entry, Set<ListArea.Appearance.Flags> flags) {
                    Sounds sound = entry.getStatus() == Job.Status.FINISHED ? (entry.isFinishedSuccessfully() ? Sounds.SELECTED : Sounds.ATTENTION) : Sounds.LIST_ITEM;
                    app.setEventResponse(DefaultEventResponse.listItem(sound, entry.getInstanceName(), null));
                }
            };
        }));
        LayoutBase.Actions jobsActions = this.actions(this.action("stop", ((Strings)app.getStrings()).actionStop(), new InputEvent(InputEvent.Special.F5), this::actStop));
        this.setAreaLayout(this.jobsArea, jobsActions);
    }

    private boolean actStop() {
        JobsManager.Entry o = this.jobsArea.selected();
        if (o == null || !(o instanceof JobsManager.Entry)) {
            return false;
        }
        JobsManager.Entry e = o;
        if (e.getStatus() == Job.Status.FINISHED) {
            return false;
        }
        e.stop();
        this.app.getLuwrain().playSound(Sounds.OK);
        return true;
    }
}

