/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.FutureTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.controls.CommanderUtils;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.InputEvent;

public class CommanderArea<E>
extends ListArea<Wrapper<E>> {
    private static final Logger log = LogManager.getLogger();
    public static final String PARENT_DIR = "..";
    protected final Model<E> model;
    protected final Appearance<E> appearance;
    protected final Set<Flags> flags;
    protected ClickHandler<E> clickHandler = null;
    protected Filter<E> filter = null;
    protected Comparator<NativeItem<E>> comparator = null;
    protected E currentLocation = null;
    protected FutureTask task = null;
    protected boolean closed = false;

    public CommanderArea(Params<E> params) {
        super(CommanderArea.createListParams(params));
        NullCheck.notNull(params.flags, (String)"params.flags");
        this.model = params.model;
        this.appearance = params.appearance;
        this.flags = params.flags;
        this.filter = params.filter;
        this.comparator = params.comparator;
        this.clickHandler = params.clickHandler;
        super.setListClickHandler((ListArea<E> area, int index, E obj) -> this.clickImpl(index, (Wrapper<E>)obj));
        ((ListModelAdapter)this.getListModel()).marking = params.flags.contains((Object)Flags.MARKING);
    }

    public Model<E> getCommanderModel() {
        return this.model;
    }

    public void setCommanderFilter(Filter<E> filter) {
        this.filter = filter;
    }

    public void setCommanderComparator(Comparator<NativeItem<E>> comparator) {
        NullCheck.notNull(comparator, (String)"comparator");
        this.comparator = comparator;
    }

    public void close() {
        this.closed = true;
    }

    public boolean findFileName(String fileName, boolean announce) {
        int index;
        NullCheck.notNull((Object)fileName, (String)"fileName");
        if (this.isEmpty()) {
            return false;
        }
        List wrappers = ((ListModelAdapter)this.getListModel()).wrappers;
        for (index = 0; index < wrappers.size() && !this.getBaseName(wrappers.get(index)).equals(fileName); ++index) {
        }
        if (index >= wrappers.size()) {
            return false;
        }
        this.select(index, false);
        if (announce) {
            Wrapper w = wrappers.get(index);
            this.appearance.announceEntry(w.obj, w.type, w.marked);
        }
        return true;
    }

    public boolean isBusy() {
        return this.task != null && !this.task.isDone();
    }

    @Override
    public boolean isEmpty() {
        return this.currentLocation == null || ((ListModelAdapter)this.getListModel()).wrappers == null || ((ListModelAdapter)this.getListModel()).wrappers.isEmpty();
    }

    protected Wrapper<E> getSelectedWrapper() {
        return (Wrapper)super.selected();
    }

    public E getSelectedEntry() {
        Wrapper<E> w = this.getSelectedWrapper();
        if (w == null) {
            return null;
        }
        return w.type != EntryType.PARENT ? (E)w.obj : null;
    }

    public String getSelectedEntryText() {
        Wrapper<E> wrapper = this.getSelectedWrapper();
        if (wrapper == null || wrapper.type == EntryType.PARENT) {
            return null;
        }
        return this.getBaseName(wrapper);
    }

    public E opened() {
        return this.currentLocation;
    }

    public Object[] getMarked() {
        if (((ListModelAdapter)this.getListModel()).wrappers == null && !this.flags.contains((Object)Flags.MARKING)) {
            return new Object[0];
        }
        ArrayList res = new ArrayList();
        for (Wrapper w : ((ListModelAdapter)this.getListModel()).wrappers) {
            if (!w.marked) continue;
            res.add(w.obj);
        }
        return res.toArray(new Object[res.size()]);
    }

    public String[] getMarkedNames() {
        if (((ListModelAdapter)this.getListModel()).wrappers == null || !this.flags.contains((Object)Flags.MARKING)) {
            return new String[0];
        }
        ArrayList<String> res = new ArrayList<String>();
        for (Wrapper w : ((ListModelAdapter)this.getListModel()).wrappers) {
            if (!w.marked) continue;
            res.add(w.baseName);
        }
        return res.toArray(new String[res.size()]);
    }

    protected Wrapper<E>[] getMarkedWrappers() {
        if (((ListModelAdapter)this.getListModel()).wrappers == null || !this.flags.contains((Object)Flags.MARKING)) {
            return new Wrapper[0];
        }
        ArrayList res = new ArrayList();
        for (Wrapper w : ((ListModelAdapter)this.getListModel()).wrappers) {
            if (!w.marked) continue;
            res.add(w);
        }
        return res.toArray(new Wrapper[res.size()]);
    }

    public boolean open(E entry) {
        Objects.requireNonNull(entry, "entry can't be null");
        return this.open(entry, null, true);
    }

    public boolean open(E entry, String desiredSelected) {
        Objects.requireNonNull(entry, "entry  can't be null");
        return this.open(entry, desiredSelected, true);
    }

    public boolean open(E entry, boolean announce) {
        NullCheck.notNull(entry, (String)"entry ");
        return this.open(entry, null, announce);
    }

    public boolean open(E entry, String desiredSelected, boolean announce) {
        NullCheck.notNull(entry, (String)"entry");
        return this.open(entry, desiredSelected, null, announce);
    }

    public boolean open(E entry, String desiredSelected, String[] desiredMarked, boolean announce) {
        NullCheck.notNull(entry, (String)"entry");
        if (this.closed || this.isBusy()) {
            return false;
        }
        E newCurrent = entry;
        String previouslySelectedText = this.getSelectedEntryText();
        this.task = new FutureTask<Object>(() -> {
            try {
                ArrayList wrappers;
                Object[] res = this.model.getEntryChildren(newCurrent);
                if (res != null) {
                    log.trace("The model returned " + res.length + " children");
                    wrappers = new ArrayList();
                    ArrayList<Object> filtered = new ArrayList<Object>();
                    filtered.ensureCapacity(res.length);
                    for (Object e : res) {
                        if (this.filter != null && !this.filter.commanderEntrySuits(e)) continue;
                        filtered.add(e);
                    }
                    wrappers.ensureCapacity(filtered.size());
                    for (Object e : filtered) {
                        EntryType entryType = this.model.getEntryType(newCurrent, e);
                        wrappers.add(new Wrapper(e, entryType, this.appearance.getEntryText(e, entryType, false)));
                    }
                    if (this.comparator != null) {
                        Collections.sort(wrappers, this.comparator);
                    }
                } else {
                    log.trace("The model returned null");
                    wrappers = null;
                }
                int index = -1;
                if (desiredSelected != null && !desiredSelected.isEmpty()) {
                    int i;
                    for (i = 0; i < wrappers.size(); ++i) {
                        Wrapper wrapper = (Wrapper)wrappers.get(i);
                        if (!desiredSelected.equals(this.appearance.getEntryText(wrapper.obj, wrapper.type, wrapper.marked))) continue;
                        index = i;
                    }
                    if (index < 0 && previouslySelectedText != null && !previouslySelectedText.isEmpty()) {
                        for (i = 0; i < wrappers.size(); ++i) {
                            Wrapper wrapper = (Wrapper)wrappers.get(i);
                            if (!previouslySelectedText.equals(this.appearance.getEntryText(wrapper.obj, wrapper.type, wrapper.marked))) continue;
                            index = i;
                        }
                    }
                }
                if (this.flags.contains((Object)Flags.MARKING) && desiredMarked != null) {
                    for (String toMark : desiredMarked) {
                        int k = 0;
                        for (k = 0; k < wrappers.size() && !((Wrapper)wrappers.get(k)).getBaseName().equals(toMark); ++k) {
                        }
                        if (k >= wrappers.size()) continue;
                        ((Wrapper)wrappers.get((int)k)).marked = true;
                    }
                }
                int finalIndex = index;
                this.context.runUiSafely(() -> this.acceptNewLocation(newCurrent, wrappers, finalIndex, announce));
            }
            catch (Throwable e) {
                log.error("Unable to open " + String.valueOf(entry), e);
                this.context.runUiSafely(() -> this.acceptNewLocation(newCurrent, null, 0, announce));
            }
        }, null);
        this.context.executeBkg(this.task);
        return true;
    }

    public boolean reread(boolean announce) {
        return this.reread(this.getSelectedEntryText(), announce);
    }

    public boolean reread(String desiredSelected, boolean announce) {
        if (this.currentLocation == null) {
            return false;
        }
        return this.open(this.currentLocation, desiredSelected, this.getMarkedNames(), announce);
    }

    protected void acceptNewLocation(E location, List<Wrapper<E>> data, int selectedIndex, boolean announce) {
        NullCheck.notNull(location, (String)"location");
        this.currentLocation = location;
        ((ListModelAdapter)this.getListModel()).wrappers = data;
        super.redraw();
        if (data != null && selectedIndex >= 0) {
            this.select(selectedIndex, false);
        } else {
            this.reset(false);
        }
        if (announce) {
            this.appearance.announceLocation(this.currentLocation);
        }
    }

    @Override
    public ListModelAdapter<E> getListModel() {
        return (ListModelAdapter)super.getListModel();
    }

    public void setClickHandler(ClickHandler<E> clickHandler) {
        this.clickHandler = clickHandler;
    }

    @Override
    public void setListClickHandler(ListArea.ClickHandler clickHandler) {
        throw new UnsupportedOperationException("Changing list click handler for commander areas not allowed, use setClickHandler(CommanderArea.ClickHandler)instead");
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.isSpecial() && !event.isModified()) {
            switch (event.getSpecial()) {
                case BACKSPACE: {
                    return this.onBackspace(event);
                }
                case INSERT: {
                    return this.onMarking(event);
                }
            }
        }
        return super.onInputEvent(event);
    }

    @Override
    public String getAreaName() {
        if (this.currentLocation == null) {
            return "";
        }
        return this.appearance.getCommanderName(this.currentLocation);
    }

    @Override
    public boolean onClipboardCopy(int fromX, int fromY, int toX, int toY, boolean withDeleting) {
        if (this.isEmpty() || withDeleting) {
            return false;
        }
        if (fromX < 0 || toX < 0 || fromX == toX && fromY == toY) {
            ArrayList<Wrapper<E>> wrappers = new ArrayList<Wrapper<E>>();
            if (this.flags.contains((Object)Flags.MARKING)) {
                wrappers.addAll(Arrays.asList(this.getMarkedWrappers()));
            } else {
                wrappers.add(this.getSelectedWrapper());
                if (((Wrapper)wrappers.get((int)0)).type == EntryType.PARENT) {
                    return false;
                }
            }
            if (wrappers.isEmpty()) {
                return super.onClipboardCopy(fromX, fromY, toX, toY, withDeleting);
            }
            return this.listClipboardSaver.saveToClipboard(this, new ListUtils.ListModel(wrappers), this.listAppearance, 0, wrappers.size(), this.context.getClipboard());
        }
        return super.onClipboardCopy(fromX, fromY, toX, toY, withDeleting);
    }

    protected boolean onBackspace(InputEvent event) {
        if (this.currentLocation == null) {
            return false;
        }
        E parent = this.model.getEntryParent(this.currentLocation);
        if (parent == null) {
            return false;
        }
        this.open(parent, this.appearance.getEntryText(this.currentLocation, EntryType.DIR, false));
        return true;
    }

    protected boolean onMarking(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (!this.flags.contains((Object)Flags.MARKING)) {
            return false;
        }
        Wrapper<E> wrapper = this.getSelectedWrapper();
        if (wrapper == null || wrapper.type == EntryType.PARENT) {
            return false;
        }
        wrapper.toggleMark();
        if (wrapper.marked) {
            this.context.setEventResponse(DefaultEventResponse.text(Sounds.SELECTED, this.context.getStaticStr("CommanderSelected") + this.getBaseName(wrapper)));
        } else {
            this.context.say("\u043d\u0435 \u0432\u044b\u0434\u0435\u043b\u0435\u043d\u043e" + this.getBaseName(wrapper), Sounds.UNSELECTED);
        }
        int index = this.selectedIndex();
        if (index >= 0 && index + 1 < this.getListItemCount()) {
            this.select(index + 1, false);
        }
        return true;
    }

    protected boolean clickImpl(int index, Wrapper<E> wrapper) {
        NullCheck.notNull(wrapper, (String)"wrapper");
        if (this.closed || this.isBusy()) {
            return false;
        }
        if (this.clickHandler == null || this.currentLocation == null) {
            return false;
        }
        if (wrapper.type == EntryType.PARENT) {
            E parent = this.model.getEntryParent(this.currentLocation);
            if (parent == null) {
                return false;
            }
            this.open(parent, this.appearance.getEntryText(this.currentLocation, EntryType.DIR, false));
            return true;
        }
        if (wrapper.type == EntryType.DIR || wrapper.type == EntryType.SYMLINK_DIR) {
            ClickHandler.Result res = this.clickHandler.onCommanderClick(this, wrapper.obj, true);
            NullCheck.notNull((Object)((Object)res), (String)"res");
            switch (res) {
                case OPEN_DIR: {
                    this.open(wrapper.obj, null);
                    return true;
                }
                case OK: {
                    return true;
                }
                case REJECTED: {
                    return false;
                }
            }
            return false;
        }
        ClickHandler.Result res = this.clickHandler.onCommanderClick(this, wrapper.obj, false);
        NullCheck.notNull((Object)((Object)res), (String)"res");
        return res == ClickHandler.Result.OK;
    }

    @Override
    protected String noContentStr() {
        return this.context.getStaticStr("CommanderNoContent");
    }

    protected String getBaseName(Wrapper wrapper) {
        NullCheck.notNull((Object)wrapper, (String)"wrapper");
        return wrapper.getBaseName();
    }

    protected static <E> ListArea.Params<Wrapper<E>> createListParams(Params<E> params) {
        NullCheck.notNull(params, (String)"params");
        NullCheck.notNull((Object)params.context, (String)"params.context");
        NullCheck.notNull(params.model, (String)"params.model");
        NullCheck.notNull(params.appearance, (String)"params.appearance");
        NullCheck.notNull(params.comparator, (String)"params.comparator");
        NullCheck.notNull(params.clipboardSaver, (String)"params.clipboardSaver");
        ListArea.Params<Wrapper<E>> listParams = new ListArea.Params<Wrapper<E>>();
        listParams.context = params.context;
        listParams.model = new ListModelAdapter(params.model, params.filter, params.comparator);
        listParams.appearance = new ListAppearanceImpl(params.appearance);
        listParams.name = "";
        listParams.clipboardSaver = params.clipboardSaver;
        return listParams;
    }

    public static class Params<E> {
        public ControlContext context = null;
        public Model<E> model = null;
        public Appearance<E> appearance = null;
        public ClickHandler<E> clickHandler = null;
        public ListArea.ClipboardSaver<Wrapper<E>> clipboardSaver = new ListUtils.DefaultClipboardSaver<Wrapper<E>>();
        public Filter<E> filter = null;
        public Comparator<NativeItem<E>> comparator = new CommanderUtils.ByNameComparator<NativeItem<E>>();
        public Set<Flags> flags = EnumSet.noneOf(Flags.class);
    }

    public static interface ClickHandler<E> {
        public Result onCommanderClick(CommanderArea var1, E var2, boolean var3);

        public static enum Result {
            OPEN_DIR,
            OK,
            REJECTED;

        }
    }

    public static interface Filter<E> {
        public boolean commanderEntrySuits(E var1);
    }

    public static interface Model<E> {
        public E[] getEntryChildren(E var1);

        public E getEntryParent(E var1);

        public EntryType getEntryType(E var1, E var2);
    }

    public static interface Appearance<E> {
        public void announceLocation(E var1);

        public void announceEntry(E var1, EntryType var2, boolean var3);

        public String getEntryText(E var1, EntryType var2, boolean var3);

        public String getCommanderName(E var1);
    }

    protected static class ListModelAdapter<E>
    implements ListArea.Model<Wrapper<E>> {
        protected final Model<E> model;
        boolean marking = true;
        List<Wrapper<E>> wrappers = null;

        public ListModelAdapter(Model<E> model, Filter<E> filter, Comparator<NativeItem<E>> comparator) {
            NullCheck.notNull(model, (String)"model");
            this.model = model;
        }

        @Override
        public int getItemCount() {
            return this.wrappers != null ? this.wrappers.size() : 0;
        }

        @Override
        public Wrapper<E> getItem(int index) {
            return this.wrappers != null ? this.wrappers.get(index) : null;
        }

        @Override
        public void refresh() {
        }
    }

    public static enum Flags {
        MARKING;

    }

    public static class Wrapper<E>
    implements NativeItem<E> {
        final E obj;
        final EntryType type;
        final String baseName;
        boolean marked = false;

        Wrapper(E obj, EntryType type, String baseName) {
            NullCheck.notNull(obj, (String)"obj");
            NullCheck.notNull((Object)((Object)type), (String)"type");
            NullCheck.notNull((Object)baseName, (String)"baseName");
            this.obj = obj;
            this.type = type;
            this.baseName = baseName;
        }

        @Override
        public E getNativeObj() {
            return this.obj;
        }

        @Override
        public boolean isDirectory() {
            return this.type == EntryType.DIR || this.type == EntryType.SYMLINK_DIR;
        }

        @Override
        public EntryType getEntryType() {
            return this.type;
        }

        @Override
        public String getBaseName() {
            return this.baseName;
        }

        void toggleMark() {
            this.marked = !this.marked;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Wrapper)) {
                return false;
            }
            Wrapper w = (Wrapper)o;
            return this.obj.equals(w.obj) && this.type == w.type;
        }
    }

    public static enum EntryType {
        REGULAR,
        DIR,
        PARENT,
        SYMLINK,
        SYMLINK_DIR,
        ARCHIVE,
        SPECIAL;

    }

    public static class ListAppearanceImpl<E>
    implements ListArea.Appearance<Wrapper<E>> {
        protected final Appearance<E> appearance;

        public ListAppearanceImpl(Appearance<E> appearance) {
            NullCheck.notNull(appearance, (String)"appearance");
            this.appearance = appearance;
        }

        @Override
        public void announceItem(Wrapper<E> wrapper, Set<ListArea.Appearance.Flags> flags) {
            NullCheck.notNull(wrapper, (String)"wrapper");
            NullCheck.notNull(flags, (String)"flags");
            this.appearance.announceEntry(wrapper.obj, wrapper.type, wrapper.marked);
        }

        @Override
        public String getScreenAppearance(Wrapper<E> wrapper, Set<ListArea.Appearance.Flags> flags) {
            NullCheck.notNull(wrapper, (String)"wrapper");
            NullCheck.notNull(flags, (String)"flags");
            boolean marked = wrapper.marked;
            EntryType type = wrapper.type;
            String name = this.appearance.getEntryText(wrapper.obj, wrapper.type, wrapper.marked);
            StringBuilder b = new StringBuilder();
            b.append(marked ? "*" : " ");
            switch (type) {
                case DIR: {
                    b.append("[");
                    break;
                }
                case SPECIAL: {
                    b.append("!");
                    break;
                }
                case SYMLINK: 
                case SYMLINK_DIR: {
                    b.append("{");
                    break;
                }
                default: {
                    b.append(" ");
                }
            }
            b.append(name);
            switch (type) {
                case DIR: {
                    b.append("]");
                    break;
                }
                case SYMLINK: 
                case SYMLINK_DIR: {
                    b.append("}");
                }
            }
            return new String(b);
        }

        @Override
        public int getObservableLeftBound(Wrapper<E> wrapper) {
            return 2;
        }

        @Override
        public int getObservableRightBound(Wrapper<E> wrapper) {
            NullCheck.notNull(wrapper, (String)"wrapper");
            return wrapper.getBaseName().length() + 2;
        }
    }

    protected static interface NativeItem<E> {
        public E getNativeObj();

        public EntryType getEntryType();

        public String getBaseName();

        public boolean isDirectory();
    }
}

