/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import org.luwrain.controls.ControlContext;
import org.luwrain.controls.TableArea;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Hint;

public class DefaultTableAppearance
implements TableArea.Appearance {
    private ControlContext environment = null;

    public DefaultTableAppearance(ControlContext environment) {
        this.environment = environment;
    }

    @Override
    public void announceRow(TableArea.Model model, int index, int flags) {
        if (model == null) {
            return;
        }
        Object value = "";
        for (int i = 0; i < model.getColCount(); ++i) {
            String text = this.getCellText(model, i, index);
            value = (String)value + (text != null ? text : "");
        }
        if (!((String)value).trim().isEmpty()) {
            this.environment.say((String)value);
        } else {
            this.environment.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
        }
    }

    @Override
    public int getInitialHotPointX(TableArea.Model model) {
        return 0;
    }

    @Override
    public String getCellText(TableArea.Model model, int col, int row) {
        if (model == null) {
            return "";
        }
        Object cell = model.getCell(col, row);
        if (cell == null) {
            return null;
        }
        String text = cell.toString();
        return text != null ? text : "";
    }

    @Override
    public String getRowPrefix(TableArea.Model model, int index) {
        return "";
    }

    @Override
    public int getColWidth(TableArea.Model model, int colIndex) {
        if (model == null) {
            return 0;
        }
        int maxLen = 0;
        for (int i = 0; i < model.getRowCount(); ++i) {
            int len = this.getCellText(model, colIndex, i).length();
            if (len <= maxLen) continue;
            maxLen = len;
        }
        return maxLen;
    }
}

