/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import java.util.function.Supplier;
import org.luwrain.controls.ListArea;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;

public class EditableListArea<E>
extends ListArea<E> {
    protected final Model<E> editableListModel;
    protected final Confirmation<E> confirmation;

    public EditableListArea(Params<E> params) {
        super(params);
        NullCheck.notNull(params, (String)"params");
        NullCheck.notNull((Object)params.model, (String)"params.model");
        if (!(params.model instanceof Model)) {
            throw new IllegalArgumentException("params.model must be an instance of EditableModel");
        }
        this.editableListModel = (Model)params.model;
        this.confirmation = params.confirmation;
    }

    public Confirmation getEditableListConfirmation() {
        return this.confirmation;
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.isSpecial() && !event.isModified()) {
            switch (event.getSpecial()) {
                case DELETE: {
                    return this.onDeleteSingle(this.getHotPointY(), true);
                }
            }
        }
        return super.onInputEvent(event);
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.getType() != SystemEvent.Type.REGULAR) {
            return super.onSystemEvent(event);
        }
        switch (event.getCode()) {
            case CLEAR: {
                return false;
            }
            case CLIPBOARD_PASTE: {
                return this.onClipboardPaste();
            }
        }
        return super.onSystemEvent(event);
    }

    @Override
    public boolean onClipboardCopy(int fromX, int fromY, int toX, int toY, boolean withDeleting) {
        if (this.isEmpty()) {
            return false;
        }
        if (fromY >= 0 && fromY == toY && fromX != toX) {
            return false;
        }
        if (!super.onClipboardCopy(fromX, fromY, toX, toY, false)) {
            return false;
        }
        if (!withDeleting) {
            return true;
        }
        if (fromX < 0 || fromY < 0 || fromX == toX && fromY == toY) {
            return this.onDeleteSingle(toY, false);
        }
        return this.onDeleteMultiple(fromY, toY, false);
    }

    @Override
    public boolean onDeleteRegion(int fromX, int fromY, int toX, int toY) {
        if (this.isEmpty()) {
            return false;
        }
        if (fromX < 0 || fromY < 0 || fromX == toX && fromY == toY) {
            return this.onDeleteSingle(toY, true);
        }
        if (fromY == toY) {
            return false;
        }
        return this.onDeleteMultiple(fromY, toY, true);
    }

    protected boolean onClipboardPaste() {
        if (this.context.getClipboard().isEmpty()) {
            return false;
        }
        int countBefore = this.listModel.getItemCount();
        int pos = this.getItemIndexOnLine(this.getHotPointY());
        if (pos < 0) {
            return false;
        }
        if (!this.editableListModel.addToModel(pos, this.context.getClipboard())) {
            return false;
        }
        int countAfter = this.listModel.getItemCount();
        if (countAfter > countBefore) {
            int newSelected = pos + (countAfter - countBefore);
            if (newSelected < countAfter) {
                this.select(newSelected, false);
            } else if (this.listFlags.contains((Object)ListArea.Flags.EMPTY_LINE_BOTTOM)) {
                this.selectEmptyLineBottom(false);
            } else {
                this.select(countAfter - 1, false);
            }
        }
        this.refresh();
        return true;
    }

    protected boolean onDeleteSingle(int lineIndex, boolean withConfirmation) {
        int index = this.getExistingItemIndexOnLine(lineIndex);
        if (index < 0) {
            return false;
        }
        if (withConfirmation && this.confirmation != null && !this.confirmation.confirmDeleting(this, this.editableListModel, index, index + 1)) {
            return true;
        }
        if (!this.editableListModel.removeFromModel(index, index + 1)) {
            return false;
        }
        this.refresh();
        return true;
    }

    protected boolean onDeleteMultiple(int fromLineIndex, int toLineIndex, boolean withConfirmation) {
        if (fromLineIndex + 1 == toLineIndex) {
            return this.onDeleteSingle(fromLineIndex, withConfirmation);
        }
        int fromIndex = this.getExistingItemIndexOnLine(fromLineIndex);
        int toIndex = this.getItemIndexOnLine(toLineIndex);
        if (fromIndex < 0 || toIndex < 0 || fromIndex >= toIndex) {
            return false;
        }
        if (withConfirmation && this.confirmation != null && !this.confirmation.confirmDeleting(this, this.editableListModel, fromIndex, toIndex)) {
            return true;
        }
        if (!this.editableListModel.removeFromModel(fromIndex, toIndex)) {
            return false;
        }
        this.refresh();
        return true;
    }

    public static class Params<E>
    extends ListArea.Params<E> {
        public Confirmation<E> confirmation = null;
    }

    public static interface Model<E>
    extends ListArea.Model<E> {
        public boolean addToModel(int var1, Supplier<Object> var2);

        public boolean removeFromModel(int var1, int var2);
    }

    public static interface Confirmation<E> {
        public boolean confirmDeleting(EditableListArea<E> var1, Model<E> var2, int var3, int var4);
    }
}

