/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import org.luwrain.controls.RegionTextQueryTranslator;
import org.luwrain.core.Lines;
import org.luwrain.core.NullCheck;

public class LinesRegionTextQueryProvider
implements RegionTextQueryTranslator.Provider {
    protected final Lines lines;

    public LinesRegionTextQueryProvider(Lines lines) {
        NullCheck.notNull((Object)lines, (String)"lines");
        this.lines = lines;
    }

    @Override
    public String onRegionTextQuery(int fromX, int fromY, int toX, int toY) {
        int count = this.lines.getLineCount();
        if (count < 1) {
            return null;
        }
        if (fromY >= count || toY > count || fromY > toY) {
            return null;
        }
        if (fromY == toY) {
            int toPos;
            String line = this.lines.getLine(fromY);
            if (line == null) {
                return null;
            }
            int fromPos = Math.min(fromX, line.length());
            if (fromPos >= (toPos = Math.min(toX, line.length()))) {
                return null;
            }
            return line.substring(fromPos, toPos);
        }
        StringBuilder b = new StringBuilder();
        String firstLine = this.lines.getLine(fromY);
        if (firstLine == null) {
            return null;
        }
        b.append(firstLine.substring(Math.min(fromX, firstLine.length())));
        for (int i = fromY + 1; i < toY; ++i) {
            String line = this.lines.getLine(i);
            if (line == null) {
                return null;
            }
            b.append("\n" + line);
        }
        String lastLine = this.lines.getLine(toY);
        if (lastLine == null) {
            return null;
        }
        b.append("\n" + lastLine.substring(0, Math.min(toX, lastLine.length())));
        return new String(b);
    }
}

