/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import java.util.ArrayList;
import org.luwrain.controls.ControlContext;
import org.luwrain.core.Action;
import org.luwrain.core.Area;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Hint;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.core.events.resp.TreeItemResponse;

public class TreeArea
implements Area {
    protected final ControlContext context;
    protected final Model model;
    protected String name = "";
    protected Node root = null;
    protected VisibleItem[] items = null;
    protected int hotPointX = 0;
    protected int hotPointY = 0;
    protected ClickHandler clickHandler = null;

    public TreeArea(Params params) {
        NullCheck.notNull((Object)params, (String)"params");
        NullCheck.notNull((Object)params.context, (String)"params.context");
        NullCheck.notNull((Object)params.model, (String)"params.model");
        NullCheck.notNull((Object)params.name, (String)"params.name");
        this.context = params.context;
        this.model = params.model;
        this.name = params.name;
        this.clickHandler = params.clickHandler;
        this.root = this.constructNode(this.model.getRoot(), null, true);
        this.items = this.generateAllVisibleItems();
    }

    public ClickHandler getClickHandler() {
        return this.clickHandler;
    }

    public void setClickHandler(ClickHandler clickHandler) {
        NullCheck.notNull((Object)clickHandler, (String)"clickHandler");
        this.clickHandler = clickHandler;
    }

    public Model getModel() {
        return this.model;
    }

    @Override
    public int getLineCount() {
        if (this.items == null || this.items.length < 1) {
            return 1;
        }
        return this.items.length + 1;
    }

    @Override
    public String getLine(int index) {
        if (this.items == null || this.items.length < 1 || index >= this.items.length) {
            return "";
        }
        return this.constructLineForScreen(this.items[index]);
    }

    @Override
    public int getHotPointX() {
        return this.hotPointX >= 0 ? this.hotPointX : 0;
    }

    @Override
    public int getHotPointY() {
        return this.hotPointY >= 0 ? this.hotPointY : 0;
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.items == null || this.items.length < 1) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.NO_CONTENT));
            return true;
        }
        if (!event.isSpecial() && !event.isModified()) {
            switch (event.getChar()) {
                case ' ': {
                    return this.onKeySpace(event);
                }
            }
        }
        if (event.isSpecial() && event.withShiftOnly()) {
            switch (event.getSpecial()) {
                case ARROW_LEFT: {
                    return this.onKeyLeft(event);
                }
                case ARROW_RIGHT: {
                    return this.onKeyRight(event);
                }
            }
        }
        if (event.isSpecial() && !event.isModified()) {
            switch (event.getSpecial()) {
                case ENTER: {
                    return this.onKeyEnter(event);
                }
                case ARROW_DOWN: {
                    return this.onKeyDown(event, false);
                }
                case ALTERNATIVE_ARROW_DOWN: {
                    return this.onKeyDown(event, true);
                }
                case ARROW_UP: {
                    return this.onKeyUp(event, false);
                }
                case ALTERNATIVE_ARROW_UP: {
                    return this.onKeyUp(event, true);
                }
                case ARROW_RIGHT: {
                    return this.onExpand(event);
                }
                case ARROW_LEFT: {
                    return this.onCollapse(event);
                }
            }
        }
        return false;
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        if (event.getCode() == SystemEvent.Code.REFRESH) {
            this.refresh();
            return true;
        }
        return false;
    }

    @Override
    public boolean onAreaQuery(AreaQuery query) {
        return false;
    }

    @Override
    public Action[] getAreaActions() {
        return new Action[0];
    }

    @Override
    public String getAreaName() {
        return this.name != null ? this.name : "";
    }

    public void refresh() {
        Object oldSelected = this.selected();
        int oldHotPointY = this.hotPointY;
        Object newRoot = this.model.getRoot();
        if (newRoot == null) {
            this.root = null;
            this.items = null;
            return;
        }
        if (this.root.obj.equals(newRoot)) {
            this.root.obj = newRoot;
            this.refreshNode(this.root);
        } else {
            this.root = this.constructNode(this.model.getRoot(), null, true);
        }
        this.items = this.generateAllVisibleItems();
        this.context.onAreaNewContent(this);
        if (oldSelected == null) {
            this.selectFirstItem();
        } else if (!this.selectObject(oldSelected)) {
            if (this.items != null && oldHotPointY < this.items.length) {
                this.hotPointY = oldHotPointY;
            } else {
                this.selectEmptyLastLine();
            }
            this.context.onAreaNewHotPoint(this);
        }
    }

    public Object selected() {
        if (this.items == null || this.hotPointY < 0 || this.hotPointY >= this.items.length) {
            return null;
        }
        return this.items[this.hotPointY].node.obj;
    }

    public boolean selectObject(Object obj) {
        int k;
        if (this.items == null || this.items.length == 0) {
            return false;
        }
        for (k = 0; k < this.items.length && !this.items[k].node.obj.equals(obj); ++k) {
        }
        if (k >= this.items.length) {
            return false;
        }
        this.hotPointY = k;
        this.hotPointX = this.getInitialHotPointX(this.hotPointY);
        this.context.onAreaNewHotPoint(this);
        return true;
    }

    public void selectEmptyLastLine() {
        this.hotPointY = this.items == null || this.items.length < 1 ? 0 : this.items.length;
        this.hotPointX = 0;
        this.context.onAreaNewHotPoint(this);
    }

    public void selectFirstItem() {
        this.hotPointY = 0;
        this.hotPointX = this.getInitialHotPointX(0);
        this.context.onAreaNewHotPoint(this);
    }

    protected void onClick(Object obj) {
        if (this.clickHandler != null) {
            this.clickHandler.onTreeClick(this, obj);
        }
    }

    protected void fillChildrenForNonLeaf(Node node) {
        if (node == null || node.obj == null) {
            return;
        }
        if (node.leaf || this.isLeaf(node.obj)) {
            node.makeLeaf();
            return;
        }
        this.model.beginChildEnumeration(node.obj);
        int count = this.model.getChildCount(node.obj);
        if (count < 1) {
            node.makeLeaf();
            this.model.endChildEnumeration(node.obj);
            return;
        }
        node.leaf = false;
        node.children = new Node[count];
        for (int i = 0; i < count; ++i) {
            Node n;
            node.children[i] = n = new Node();
            n.obj = this.model.getChild(node.obj, i);
            if (n.obj == null) {
                node.makeLeaf();
                this.model.endChildEnumeration(node.obj);
                return;
            }
            n.leaf = this.isLeaf(n.obj);
            n.children = null;
            n.parent = node;
        }
        this.model.endChildEnumeration(node.obj);
    }

    protected Node constructNode(Object obj, Node parent, boolean fillChildren) {
        if (obj == null) {
            return null;
        }
        Node node = new Node();
        node.obj = obj;
        node.parent = parent;
        node.leaf = this.isLeaf(obj);
        if (fillChildren && !node.leaf) {
            this.fillChildrenForNonLeaf(node);
        }
        return node;
    }

    protected void refreshNode(Node node) {
        if (node == null || node.obj == null) {
            return;
        }
        if (node.leaf) {
            node.leaf = this.isLeaf(node.obj);
            return;
        }
        if (this.isLeaf(node.obj)) {
            node.makeLeaf();
            return;
        }
        if (node.children == null) {
            return;
        }
        this.model.beginChildEnumeration(node.obj);
        int newCount = this.model.getChildCount(node.obj);
        if (newCount == 0) {
            node.makeLeaf();
            this.model.endChildEnumeration(node.obj);
            return;
        }
        Node[] newNodes = new Node[newCount];
        for (int i = 0; i < newCount; ++i) {
            int k;
            Object newObj = this.model.getChild(node.obj, i);
            if (newObj == null) {
                node.makeLeaf();
                this.model.endChildEnumeration(node.obj);
                return;
            }
            for (k = 0; k < node.children.length && !node.children[k].obj.equals(newObj); ++k) {
            }
            if (k < node.children.length) {
                newNodes[i] = node.children[k];
                newNodes[i].obj = newObj;
                continue;
            }
            newNodes[i] = this.constructNode(newObj, node, false);
        }
        this.model.endChildEnumeration(node.obj);
        for (Node n : node.children = newNodes) {
            this.refreshNode(n);
        }
    }

    protected boolean onKeySpace(InputEvent event) {
        if (this.items == null) {
            return false;
        }
        if (this.hotPointY >= this.items.length) {
            return false;
        }
        VisibleItem item = this.items[this.hotPointY];
        if (item.node.obj != null) {
            this.onClick(item.node.obj);
        }
        return true;
    }

    protected boolean onKeyEnter(InputEvent event) {
        if (event.isModified() || this.items == null || this.hotPointY >= this.items.length) {
            return false;
        }
        VisibleItem item = this.items[this.hotPointY];
        if (item.type == VisibleItem.Type.LEAF) {
            this.onClick(item.node.obj);
            return true;
        }
        if (item.type == VisibleItem.Type.CLOSED) {
            this.fillChildrenForNonLeaf(item.node);
            this.items = this.generateAllVisibleItems();
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.TREE_BRANCH_EXPANDED));
            this.context.onAreaNewContent(this);
            return true;
        }
        if (item.type == VisibleItem.Type.OPENED) {
            item.node.children = null;
            this.items = this.generateAllVisibleItems();
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.TREE_BRANCH_COLLAPSED));
            this.context.onAreaNewContent(this);
            return true;
        }
        return false;
    }

    protected boolean onExpand(InputEvent event) {
        if (event.isModified() || this.items == null || this.hotPointY >= this.items.length) {
            return false;
        }
        VisibleItem item = this.items[this.hotPointY];
        switch (item.type) {
            case LEAF: 
            case OPENED: {
                return false;
            }
            case CLOSED: {
                this.fillChildrenForNonLeaf(item.node);
                this.items = this.generateAllVisibleItems();
                this.context.setEventResponse(DefaultEventResponse.hint(Hint.TREE_BRANCH_EXPANDED));
                this.context.onAreaNewContent(this);
                return true;
            }
        }
        return false;
    }

    protected boolean onCollapse(InputEvent event) {
        if (event.isModified() || this.items == null || this.hotPointY >= this.items.length) {
            return false;
        }
        VisibleItem item = this.items[this.hotPointY];
        switch (item.type) {
            case LEAF: 
            case CLOSED: {
                return false;
            }
            case OPENED: {
                item.node.children = null;
                this.items = this.generateAllVisibleItems();
                this.context.setEventResponse(DefaultEventResponse.hint(Hint.TREE_BRANCH_COLLAPSED));
                this.context.onAreaNewContent(this);
                return true;
            }
        }
        return false;
    }

    protected boolean onKeyDown(InputEvent event, boolean briefAnnouncement) {
        if (event.isModified() || this.items == null) {
            return false;
        }
        if (this.hotPointY >= this.items.length) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.TREE_END));
            return true;
        }
        ++this.hotPointY;
        if (this.hotPointY >= this.items.length) {
            this.hotPointX = 0;
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
        } else {
            this.hotPointX = this.getInitialHotPointX(this.hotPointY);
            this.announce(this.items[this.hotPointY], briefAnnouncement);
        }
        this.context.onAreaNewHotPoint(this);
        return true;
    }

    protected boolean onKeyUp(InputEvent event, boolean briefAnnouncement) {
        if (event.isModified() || this.items == null) {
            return false;
        }
        if (this.hotPointY <= 0) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.TREE_BEGIN));
            return true;
        }
        --this.hotPointY;
        this.hotPointX = this.getInitialHotPointX(this.hotPointY);
        this.announce(this.items[this.hotPointY], briefAnnouncement);
        this.context.onAreaNewHotPoint(this);
        return true;
    }

    protected boolean onKeyRight(InputEvent event) {
        if (this.items == null || this.hotPointY >= this.items.length) {
            return false;
        }
        String value = this.items[this.hotPointY].title;
        int offset = this.getInitialHotPointX(this.hotPointY);
        if (value.isEmpty()) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
            return true;
        }
        if (this.hotPointX >= value.length() + offset) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.END_OF_LINE));
            return true;
        }
        this.hotPointX = this.hotPointX < offset ? offset : ++this.hotPointX;
        if (this.hotPointX >= value.length() + offset) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.END_OF_LINE));
        } else {
            this.context.sayLetter(value.charAt(this.hotPointX - offset));
        }
        this.context.onAreaNewHotPoint(this);
        return true;
    }

    protected boolean onKeyLeft(InputEvent event) {
        if (this.items == null || this.hotPointY >= this.items.length) {
            return false;
        }
        String value = this.items[this.hotPointY].title;
        int offset = this.getInitialHotPointX(this.hotPointY);
        if (value.isEmpty()) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
            return true;
        }
        if (this.hotPointX <= offset) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.BEGIN_OF_LINE));
            return true;
        }
        this.hotPointX = this.hotPointX >= value.length() + offset ? value.length() + offset - 1 : --this.hotPointX;
        this.context.sayLetter(value.charAt(this.hotPointX - offset));
        this.context.onAreaNewHotPoint(this);
        return true;
    }

    protected VisibleItem[] generateVisibleItems(Node node, int level) {
        if (node == null) {
            return null;
        }
        VisibleItem itself = new VisibleItem();
        itself.node = node;
        itself.title = node.title();
        itself.level = level;
        if (node.leaf || node.children == null) {
            itself.type = node.leaf ? VisibleItem.Type.LEAF : VisibleItem.Type.CLOSED;
            VisibleItem[] res = new VisibleItem[]{itself};
            return res;
        }
        itself.type = VisibleItem.Type.OPENED;
        ArrayList<VisibleItem> items = new ArrayList<VisibleItem>();
        items.add(itself);
        for (int i = 0; i < node.children.length; ++i) {
            VisibleItem[] c = this.generateVisibleItems(node.children[i], level + 1);
            if (c == null) continue;
            for (VisibleItem v : c) {
                items.add(v);
            }
        }
        VisibleItem[] res = new VisibleItem[items.size()];
        int k = 0;
        for (VisibleItem i : items) {
            res[k++] = i;
        }
        return res;
    }

    protected VisibleItem[] generateAllVisibleItems() {
        if (this.root == null) {
            return null;
        }
        return this.generateVisibleItems(this.root, 0);
    }

    protected boolean isLeaf(Object o) {
        NullCheck.notNull((Object)o, (String)"o");
        this.model.beginChildEnumeration(o);
        boolean res = this.model.getChildCount(o) <= 0;
        this.model.endChildEnumeration(o);
        return res;
    }

    protected void announce(VisibleItem item, boolean briefAnnouncement) {
        NullCheck.notNull((Object)item, (String)"item");
        if (item.title.isEmpty()) {
            this.context.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
            return;
        }
        if (briefAnnouncement) {
            this.context.setEventResponse(DefaultEventResponse.text(item.title));
            return;
        }
        String res = item.title;
        this.context.setEventResponse(DefaultEventResponse.treeItem(switch (item.type) {
            case VisibleItem.Type.OPENED -> TreeItemResponse.Type.EXPANDED;
            case VisibleItem.Type.CLOSED -> TreeItemResponse.Type.COLLAPSED;
            default -> TreeItemResponse.Type.LEAF;
        }, item.title, item.level + 1));
    }

    protected String constructLineForScreen(VisibleItem item) {
        if (item == null) {
            return "";
        }
        Object res = "";
        for (int i = 0; i < item.level; ++i) {
            res = (String)res + "  ";
        }
        switch (item.type) {
            case OPENED: {
                res = (String)res + " -";
                break;
            }
            case CLOSED: {
                res = (String)res + " +";
                break;
            }
            default: {
                res = (String)res + "  ";
            }
        }
        return (String)res + (item.title != null ? item.title : "");
    }

    protected int getInitialHotPointX(int index) {
        if (this.items == null || index >= this.items.length) {
            return 0;
        }
        return this.items[index].level * 2 + 2;
    }

    protected static class Node {
        Object obj = null;
        Node parent = null;
        Node[] children = null;
        boolean leaf = true;

        protected Node() {
        }

        void makeLeaf() {
            this.children = null;
            this.leaf = true;
        }

        String title() {
            return this.obj != null ? this.obj.toString() : "";
        }
    }

    protected static class VisibleItem {
        Type type = Type.LEAF;
        String title = "";
        int level = 0;
        Node node;

        protected VisibleItem() {
        }

        static enum Type {
            LEAF,
            CLOSED,
            OPENED;

        }
    }

    public static interface ClickHandler {
        public boolean onTreeClick(TreeArea var1, Object var2);
    }

    public static final class Params {
        public ControlContext context;
        public String name;
        public Model model;
        public ClickHandler clickHandler;
    }

    public static interface Model {
        public Object getRoot();

        public void beginChildEnumeration(Object var1);

        public int getChildCount(Object var1);

        public Object getChild(Object var1, int var2);

        public void endChildEnumeration(Object var1);
    }
}

