/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.FormArea;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.InputEvent;
import org.luwrain.util.TextUtils;

public class WizardArea
extends FormArea {
    protected final Values values = new Values();
    protected WizardClickable defaultClickable = null;
    protected int clickableCount = 0;

    public WizardArea(ControlContext context) {
        super(context);
    }

    public Frame newFrame() {
        return new Frame();
    }

    public void show(Frame frame) {
        NullCheck.notNull((Object)frame, (String)"frame");
        this.clear();
        this.values.edits.clear();
        this.defaultClickable = null;
        this.clickableCount = 0;
        if (frame.getItems().length == 0) {
            return;
        }
        boolean emptyLine = true;
        for (WizardItem i : frame.getItems()) {
            String name;
            WizardItem c;
            if (i instanceof WizardText) {
                this.addStatic("");
                WizardText t = (WizardText)i;
                for (String l : TextUtils.wordWrap(t.getText(), 80)) {
                    this.addStatic(l);
                }
                emptyLine = true;
                continue;
            }
            if (i instanceof WizardClickable) {
                if (emptyLine) {
                    this.addStatic("");
                }
                c = (WizardClickable)i;
                ++this.clickableCount;
                this.defaultClickable = c;
                this.addStatic(this.getItemNewAutoName(), ((WizardClickable)c).getText(), c);
                emptyLine = false;
                continue;
            }
            if (i instanceof WizardInput) {
                if (emptyLine) {
                    this.addStatic("");
                }
                c = (WizardInput)i;
                name = this.getItemNewAutoName();
                this.values.addEdit(name);
                this.addEdit(name, ((WizardInput)c).getPrefix(), ((WizardInput)c).getText(), c, true);
                emptyLine = false;
                continue;
            }
            if (!(i instanceof WizardPasswd)) continue;
            if (emptyLine) {
                this.addStatic("");
            }
            c = (WizardPasswd)i;
            name = this.getItemNewAutoName();
            this.values.addEdit(name);
            this.addPasswd(name, ((WizardPasswd)c).getPrefix(), ((WizardPasswd)c).getText(), c, true);
            emptyLine = false;
        }
    }

    protected boolean defaultClick() {
        if (this.clickableCount != 1 || this.defaultClickable == null) {
            return false;
        }
        return this.defaultClickable.click(this.values);
    }

    protected boolean onClick() {
        String itemName = this.getItemNameOnLine(this.getHotPointY());
        if (itemName == null || itemName.isEmpty()) {
            return this.defaultClick();
        }
        Object obj = this.getItemObjByName(itemName);
        if (obj == null) {
            return this.defaultClick();
        }
        if (obj instanceof WizardClickable) {
            WizardClickable c = (WizardClickable)obj;
            return c.click(this.values);
        }
        return this.defaultClick();
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.isSpecial() && !event.isModified()) {
            switch (event.getSpecial()) {
                case ENTER: {
                    if (this.onClick()) {
                        return true;
                    }
                    return super.onInputEvent(event);
                }
            }
        }
        return super.onInputEvent(event);
    }

    @Override
    public void announceLine(int index, String line) {
        NullCheck.notNull((Object)line, (String)"line");
        if (line.trim().isEmpty()) {
            super.announceLine(index, line);
            return;
        }
        String name = this.getItemNameOnLine(index);
        if (name == null || name.isEmpty()) {
            super.announceLine(index, line);
            return;
        }
        Object obj = this.getItemObjByName(name);
        if (obj == null || !(obj instanceof WizardClickable)) {
            super.announceLine(index, line);
            return;
        }
        this.context.setEventResponse(DefaultEventResponse.text(Sounds.MARKED_LIST_ITEM, this.context.getSpeakableText(line, Luwrain.SpeakableTextType.NATURAL)));
    }

    protected final class Values
    implements WizardValues {
        final List<String> edits = new ArrayList<String>();

        protected Values() {
        }

        public void addEdit(String name) {
            NullCheck.notEmpty((Object)name, (String)"name");
            this.edits.add(name);
        }

        @Override
        public String getText(int index) {
            if (index < 0 || index >= this.edits.size()) {
                throw new IllegalArgumentException("Illegal index (" + String.valueOf(index) + "), the edit list contains " + String.valueOf(this.edits.size()) + " items");
            }
            return WizardArea.this.getEnteredText(this.edits.get(index));
        }
    }

    public final class WizardClickable
    implements WizardItem {
        private final String text;
        private final WizardClickHandler handler;

        public WizardClickable(String text, WizardClickHandler handler) {
            NullCheck.notEmpty((Object)text, (String)"text");
            NullCheck.notNull((Object)handler, (String)"handler");
            this.text = text;
            this.handler = handler;
        }

        public String getText() {
            return this.text;
        }

        public boolean click(WizardValues values) {
            NullCheck.notNull((Object)values, (String)"values");
            return this.handler.handle(values);
        }
    }

    public final class Frame {
        private final List<WizardItem> items = new ArrayList<WizardItem>();

        public Frame addText(String text) {
            NullCheck.notEmpty((Object)text, (String)"text");
            this.items.add(new WizardText(text));
            return this;
        }

        public Frame addClickable(String text, WizardClickHandler handler) {
            NullCheck.notEmpty((Object)text, (String)"text");
            Objects.requireNonNull(handler, "handler can't be null");
            this.items.add(new WizardClickable(text, handler));
            return this;
        }

        public Frame addInput(String prefix, String text) {
            NullCheck.notNull((Object)prefix, (String)"prefix");
            NullCheck.notNull((Object)text, (String)"text");
            this.items.add(new WizardInput(prefix, text));
            return this;
        }

        public Frame addINput(String prefix) {
            NullCheck.notNull((Object)prefix, (String)"prefix");
            return this.addInput(prefix, "");
        }

        public Frame addPasswd(String prefix, String text) {
            NullCheck.notNull((Object)prefix, (String)"prefix");
            NullCheck.notNull((Object)text, (String)"text");
            this.items.add(new WizardPasswd(prefix, text));
            return this;
        }

        public Frame addPasswd(String prefix) {
            NullCheck.notNull((Object)prefix, (String)"prefix");
            return this.addPasswd(prefix, "");
        }

        WizardItem[] getItems() {
            return this.items.toArray(new WizardItem[this.items.size()]);
        }
    }

    public static interface WizardItem {
    }

    public final class WizardText
    implements WizardItem {
        private final String text;

        public WizardText(String text) {
            NullCheck.notEmpty((Object)text, (String)"text");
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }

    public final class WizardInput
    implements WizardItem {
        private final String prefix;
        private final String text;

        public WizardInput(String prefix, String text) {
            NullCheck.notNull((Object)prefix, (String)"prefix");
            NullCheck.notNull((Object)text, (String)"text");
            this.prefix = prefix;
            this.text = text;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getText() {
            return this.text;
        }
    }

    public final class WizardPasswd
    implements WizardItem {
        private final String prefix;
        private final String text;

        public WizardPasswd(String prefix, String text) {
            NullCheck.notNull((Object)prefix, (String)"prefix");
            NullCheck.notNull((Object)text, (String)"text");
            this.prefix = prefix;
            this.text = text;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getText() {
            return this.text;
        }
    }

    public static interface WizardValues {
        public String getText(int var1);
    }

    public static interface WizardClickHandler {
        public boolean handle(WizardValues var1);
    }
}

