/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls.edit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.MutableMarkedLinesImpl;
import org.luwrain.controls.NavigationArea;
import org.luwrain.controls.edit.DefaultEditAreaAppearance;
import org.luwrain.controls.edit.MultilineEdit;
import org.luwrain.controls.edit.MultilineEditTranslator;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.HotPoint;
import org.luwrain.core.HotPointControl;
import org.luwrain.core.MarkedLines;
import org.luwrain.core.MutableMarkedLines;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.script.Hooks;
import org.luwrain.script.controls.EditSingleLineUpdateObj;
import org.luwrain.script.controls.EditUpdateObj;
import org.luwrain.script.core.InputEventObj;

public class EditArea
extends NavigationArea {
    private static final Logger log = LogManager.getLogger();
    protected final MutableMarkedLines content;
    protected final MultilineEditTranslator translator;
    protected final Appearance appearance;
    protected String areaName = "";
    protected final List<ChangeListener> changeListeners = new ArrayList<ChangeListener>();
    protected final MultilineEdit edit;
    protected final List<InputEventListener> inputEventListeners;

    public EditArea(Params params) {
        super(params.context);
        Objects.requireNonNull(params, "params can't be null");
        Objects.requireNonNull(params.appearance, "params.appearance can't be null");
        Objects.requireNonNull(params.name, "params.name can't be null");
        this.areaName = params.name;
        this.content = params.content != null ? params.content : new MutableMarkedLinesImpl();
        this.appearance = params.appearance;
        if (params.changeListeners != null) {
            this.changeListeners.addAll(params.changeListeners);
        }
        this.translator = new MultilineEditTranslator(this.content, this);
        this.edit = this.createEdit(params);
        this.inputEventListeners = params.inputEventListeners != null ? new ArrayList<InputEventListener>(params.inputEventListeners) : new ArrayList<InputEventListener>();
    }

    public void setChangeListeners(List<ChangeListener> listeners) {
        Objects.requireNonNull(listeners, "listeners can't be null");
        this.changeListeners.clear();
        this.changeListeners.addAll(listeners);
    }

    protected MultilineEdit createEdit(Params areaParams) {
        MultilineEdit.Params params;
        Objects.requireNonNull(areaParams, "areaParams can't be null");
        if (areaParams.editFactory != null) {
            params = new MultilineEdit.Params();
            params.context = this.context;
            params.model = this.translator;
            params.appearance = areaParams.appearance;
            params.regionPoint = this.regionPoint;
            MultilineEdit edit = areaParams.editFactory.newMultilineEdit(params);
            if (edit != null) {
                return edit;
            }
        }
        params = new MultilineEdit.Params();
        params.context = this.context;
        params.model = this.translator;
        params.appearance = areaParams.appearance;
        params.regionPoint = this.regionPoint;
        return new MultilineEdit(params);
    }

    public MultilineEdit getEdit() {
        return this.edit;
    }

    @Override
    public int getLineCount() {
        int value = this.content.getLineCount();
        return value > 0 ? value : 1;
    }

    @Override
    public String getLine(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index (" + index + ") may not be negative");
        }
        if (index >= this.content.getLineCount()) {
            return "";
        }
        String line = this.content.getLine(index);
        return line != null ? line : "";
    }

    public void setLine(int index, String line) {
        Objects.requireNonNull(line, "line can't be null");
        if (index < 0) {
            throw new IllegalArgumentException("index (" + index + ") may not be negative");
        }
        this.content.setLine(index, line);
        this.context.onAreaNewContent(this);
    }

    @Override
    public String getAreaName() {
        return this.areaName;
    }

    public void setAreaName(String areaName) {
        NullCheck.notNull((Object)areaName, (String)"areaName");
        this.areaName = areaName;
        this.context.onAreaNewName(this);
    }

    public List<String> getTextAsList() {
        return Arrays.asList(this.content.getLines());
    }

    public String[] getText() {
        return this.content.getLines();
    }

    public String getText(String lineSeparator) {
        if (this.content.getLineCount() == 0) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        b.append(this.content.getLine(0));
        for (int i = 1; i < this.content.getLineCount(); ++i) {
            b.append(lineSeparator).append(this.content.getLine(i));
        }
        return new String(b);
    }

    public void setText(String[] lines) {
        NullCheck.notNullItems((Object[])lines, (String)"lines");
        this.content.setLines(lines);
        this.context.onAreaNewContent(this);
        this.setHotPoint(this.getHotPointX(), this.getHotPointY());
    }

    public boolean update(EditUpdating updating) {
        Objects.requireNonNull(updating, "updating can't be null");
        if (!updating.editUpdate(this.content, this)) {
            this.redraw();
            return false;
        }
        this.redraw();
        this.notifyChangeListeners();
        return true;
    }

    public void clear() {
        this.content.clear();
        this.context.onAreaNewContent(this);
        this.setHotPoint(0, 0);
    }

    public MutableMarkedLines getContent() {
        return this.content;
    }

    public void refresh() {
        this.redraw();
        this.context.onAreaNewName(this);
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        Objects.requireNonNull(event, "event can't be null");
        if (this.inputEventListeners != null) {
            for (InputEventListener l : this.inputEventListeners) {
                log.debug("Running edit input event listener");
                if (!l.onEditAreaInputEvent(this, event)) continue;
                log.debug("true result");
                return true;
            }
        }
        if (this.edit.onInputEvent(event)) {
            if (this.translator.commit()) {
                this.refresh();
                this.notifyChangeListeners();
            }
            return true;
        }
        return super.onInputEvent(event);
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.edit.onSystemEvent(event)) {
            if (this.translator.commit()) {
                this.refresh();
                this.notifyChangeListeners();
            }
            return true;
        }
        return super.onSystemEvent(event);
    }

    @Override
    public boolean onAreaQuery(AreaQuery query) {
        Objects.requireNonNull(query, "query can't be null");
        if (this.edit.onAreaQuery(query)) {
            return true;
        }
        return super.onAreaQuery(query);
    }

    @Override
    public void announceLine(int index, String line) {
        NullCheck.notNull((Object)line, (String)"line");
        this.appearance.announceLine(index, line);
    }

    public Appearance getEditAppearance() {
        return this.appearance;
    }

    protected String getTabSeq() {
        return "\t";
    }

    protected void notifyChangeListeners() {
        for (ChangeListener l : this.changeListeners) {
            l.onEditChange(this, this.content, this);
        }
    }

    public static final class Params {
        public ControlContext context = null;
        public Appearance appearance = null;
        public String name = "";
        public MutableMarkedLines content = null;
        public List<ChangeListener> changeListeners = null;
        public List<InputEventListener> inputEventListeners = null;
        public EditFactory editFactory = null;

        public Params() {
        }

        public Params(ControlContext context) {
            Objects.requireNonNull(context, "context can't be null");
            this.context = context;
            this.appearance = new DefaultEditAreaAppearance(context);
            this.inputEventListeners = new ArrayList<InputEventListener>();
            this.inputEventListeners.add((edit, event) -> edit.update((lines, hotPoint) -> Hooks.chainOfResponsibilityNoExc(context, "luwrain.edit.input", new Object[]{new EditUpdateObj(lines, hotPoint), new InputEventObj(event)})));
            this.inputEventListeners.add((edit, event) -> edit.update((lines, hotPoint) -> Hooks.chainOfResponsibilityNoExc(context, "luwrain.text.input.single", new Object[]{new EditSingleLineUpdateObj(lines, hotPoint), new InputEventObj(event)})));
        }
    }

    public static interface Appearance
    extends MultilineEdit.Appearance {
        public void announceLine(int var1, String var2);
    }

    public static interface EditFactory {
        public MultilineEdit newMultilineEdit(MultilineEdit.Params var1);
    }

    public static interface EditUpdating {
        public boolean editUpdate(MutableMarkedLines var1, HotPointControl var2);
    }

    public static interface InputEventListener {
        public boolean onEditAreaInputEvent(EditArea var1, InputEvent var2);
    }

    public static interface ChangeListener {
        public void onEditChange(EditArea var1, MarkedLines var2, HotPoint var3);
    }
}

