/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls.edit;

import java.util.List;
import java.util.Objects;
import org.luwrain.controls.edit.MultilineEdit;
import org.luwrain.core.HotPointControl;
import org.luwrain.core.MutableLines;

public interface MultilineCorrector {
    public void change(Change var1);

    public static final class SplitLineChange
    extends Change {
        public SplitLineChange(int line, int pos) {
            super(ChangeType.SPLIT_LINE, line, pos);
        }
    }

    public static final class MergeLinesChange
    extends Change {
        public MergeLinesChange(int firstLine) {
            super(ChangeType.MERGE_LINES, firstLine, 0);
        }

        @Override
        public int getPos() {
            throw new IllegalArgumentException("pos is meaningless for MergeLinesChange");
        }
    }

    public static final class InsertCharsChange
    extends Change {
        protected final String chars;

        public InsertCharsChange(int line, int pos, String chars) {
            super(ChangeType.INSERT_CHARS, line, pos);
            Objects.requireNonNull(chars, "chars can't be null");
            if (chars.isEmpty()) {
                throw new IllegalArgumentException("chars can't be empty");
            }
            this.chars = chars;
        }

        public String getChars() {
            return this.chars;
        }
    }

    public static final class InsertFragmentChange
    extends Change {
        protected final List<String> text;

        public InsertFragmentChange(int line, int pos, List<String> text) {
            super(ChangeType.INSERT_FRAGMENT, line, pos);
            this.text = text;
        }

        public List<String> getText() {
            return this.text;
        }
    }

    public static final class DeleteFragmentChange
    extends Change {
        protected final int lineTo;
        protected final int posTo;

        public DeleteFragmentChange(int line, int pos, int lineTo, int posTo) {
            super(ChangeType.DELETE_FRAGMENT, line, pos);
            this.lineTo = lineTo;
            this.posTo = posTo;
        }
    }

    public static final class DeleteCharChange
    extends Change {
        public DeleteCharChange(int line, int pos) {
            super(ChangeType.DELETE_CHAR, line, pos);
        }
    }

    public static class Change {
        protected final ChangeType type;
        protected final int line;
        protected final int pos;
        protected MultilineEdit.ModificationResult result = null;

        public Change(ChangeType type, int line, int pos) {
            Objects.requireNonNull(type, "type can't be null");
            if (line < 0) {
                throw new IllegalArgumentException("line can't be negative (" + String.valueOf(line) + ")");
            }
            if (pos < 0) {
                throw new IllegalArgumentException("pos can't be negative (" + String.valueOf(pos) + ")");
            }
            this.type = type;
            this.line = line;
            this.pos = pos;
        }

        public ChangeType getType() {
            return this.type;
        }

        public int getLine() {
            return this.line;
        }

        public int getPos() {
            return this.pos;
        }

        public void setResult(MultilineEdit.ModificationResult result) {
            this.result = result;
        }

        public MultilineEdit.ModificationResult getResult() {
            return this.result;
        }
    }

    public static interface Model
    extends MutableLines,
    HotPointControl {
        public void change(Change var1);
    }

    public static enum ChangeType {
        INSERT_CHARS,
        DELETE_CHAR,
        INSERT_FRAGMENT,
        DELETE_FRAGMENT,
        MERGE_LINES,
        SPLIT_LINE;

    }
}

