/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.controls.edit;

import java.util.EnumSet;
import org.luwrain.controls.AbstractRegionPoint;
import org.luwrain.controls.ClipboardTranslator;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.LinesClipboardProvider;
import org.luwrain.controls.LinesRegionTextQueryProvider;
import org.luwrain.controls.RegionTextQueryTranslator;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.Lines;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.core.queries.RegionTextQuery;

public class MultilineEdit {
    protected final ControlContext context;
    protected final Model model;
    protected final Appearance appearance;
    protected final AbstractRegionPoint regionPoint;
    protected final ClipboardTranslator clipboardTranslator;
    protected final RegionTextQueryTranslator regionTextQueryTranslator;

    public MultilineEdit(Params params) {
        NullCheck.notNull((Object)params, (String)"params");
        NullCheck.notNull((Object)params.model, (String)"params.model");
        NullCheck.notNull((Object)params.appearance, (String)"params.appearance");
        NullCheck.notNull((Object)params.regionPoint, (String)"params.regionPoint");
        this.context = params.context;
        this.regionPoint = params.regionPoint;
        this.model = params.model;
        this.appearance = params.appearance;
        this.clipboardTranslator = new ClipboardTranslator(new LinesClipboardProvider(this.model, () -> this.context.getClipboard()){

            @Override
            public boolean onClipboardCopy(int fromX, int fromY, int toX, int toY, boolean withDeleting) {
                if (!super.onClipboardCopy(fromX, fromY, toX, toY, false)) {
                    return false;
                }
                if (!withDeleting) {
                    return true;
                }
                ModificationResult res = MultilineEdit.this.model.deleteRegion(fromX, fromY, toX, toY);
                return res != null ? res.isPerformed() : false;
            }

            @Override
            public boolean onDeleteRegion(int fromX, int fromY, int toX, int toY) {
                ModificationResult res = MultilineEdit.this.model.deleteRegion(fromX, fromY, toX, toY);
                return res != null ? Boolean.valueOf(res.isPerformed()) : null;
            }
        }, this.regionPoint, EnumSet.noneOf(ClipboardTranslator.Flags.class));
        this.regionTextQueryTranslator = new RegionTextQueryTranslator(new LinesRegionTextQueryProvider(this.model), this.regionPoint, EnumSet.noneOf(RegionTextQueryTranslator.Flags.class));
    }

    public Model getMultilineEditModel() {
        return this.model;
    }

    public Appearance getMultilineEditAppearance() {
        return this.appearance;
    }

    public String[] getRegionText() {
        RegionTextQuery query = new RegionTextQuery();
        if (!this.regionTextQueryTranslator.onAreaQuery(query, this.model.getHotPointX(), this.model.getHotPointY())) {
            return null;
        }
        String res = query.getAnswer();
        if (res == null) {
            return null;
        }
        if (res.isEmpty()) {
            return new String[0];
        }
        return res.split("\n", -1);
    }

    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (!event.isSpecial()) {
            return this.onChar(event);
        }
        if (event.isModified()) {
            return false;
        }
        switch (event.getSpecial()) {
            case BACKSPACE: {
                return this.onBackspace(event);
            }
            case DELETE: {
                return this.onDelete(event);
            }
            case TAB: {
                return this.onTab(event);
            }
            case ENTER: {
                return this.onEnter(event);
            }
        }
        return false;
    }

    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.getType() != SystemEvent.Type.REGULAR) {
            return false;
        }
        switch (event.getCode()) {
            case CLEAR: {
                return false;
            }
            case CLIPBOARD_PASTE: {
                return this.onClipboardPaste();
            }
        }
        if (this.clipboardTranslator.onSystemEvent(event, this.model.getHotPointX(), this.model.getHotPointY())) {
            return true;
        }
        return this.regionTextQueryTranslator.onSystemEvent(event, this.model.getHotPointX(), this.model.getHotPointY());
    }

    public boolean onAreaQuery(AreaQuery query) {
        NullCheck.notNull((Object)query, (String)"query");
        return this.regionTextQueryTranslator.onAreaQuery(query, this.model.getHotPointX(), this.model.getHotPointY());
    }

    protected boolean onBackspace(InputEvent event) {
        if (this.model.getHotPointY() >= this.model.getLineCount()) {
            return false;
        }
        if (this.model.getHotPointX() <= 0 && this.model.getHotPointY() <= 0) {
            return this.appearance.onBackspaceTextBegin();
        }
        if (this.model.getHotPointX() <= 0) {
            ModificationResult res = this.model.mergeLines(this.model.getHotPointY() - 1);
            return this.appearance.onBackspaceMergeLines(res);
        }
        ModificationResult res = this.model.deleteChar(this.model.getHotPointX() - 1, this.model.getHotPointY());
        return this.appearance.onBackspaceDeleteChar(res);
    }

    protected boolean onDelete(InputEvent event) {
        if (this.model.getHotPointY() >= this.model.getLineCount()) {
            return false;
        }
        String line = this.model.getLine(this.model.getHotPointY());
        if (line == null) {
            return false;
        }
        if (this.model.getHotPointX() < line.length()) {
            ModificationResult res = this.model.deleteChar(this.model.getHotPointX(), this.model.getHotPointY());
            return this.appearance.onDeleteChar(res);
        }
        if (this.model.getHotPointY() + 1 >= this.model.getLineCount()) {
            return this.appearance.onDeleteCharTextEnd();
        }
        ModificationResult res = this.model.mergeLines(this.model.getHotPointY());
        return this.appearance.onDeleteCharMergeLines(res);
    }

    protected boolean onTab(InputEvent event) {
        String tabSeq = this.model.getTabSeq();
        if (tabSeq == null) {
            return false;
        }
        ModificationResult res = this.model.putChars(this.model.getHotPointX(), this.model.getHotPointY(), tabSeq);
        return this.appearance.onTab(res);
    }

    protected boolean onEnter(InputEvent event) {
        ModificationResult res = this.model.splitLine(this.model.getHotPointX(), this.model.getHotPointY());
        return this.appearance.onSplitLines(res);
    }

    protected boolean onChar(InputEvent event) {
        char c = event.getChar();
        ModificationResult res = this.model.putChars(this.model.getHotPointX(), this.model.getHotPointY(), Character.valueOf(c).toString());
        return this.appearance.onChar(res);
    }

    protected boolean onClipboardPaste() {
        if (this.context.getClipboard().isEmpty()) {
            return false;
        }
        ModificationResult res = this.model.insertRegion(this.model.getHotPointX(), this.model.getHotPointY(), this.context.getClipboard().getStrings());
        return res != null ? res.isPerformed() : false;
    }

    public static final class Params {
        public ControlContext context = null;
        public Model model = null;
        public Appearance appearance = null;
        public AbstractRegionPoint regionPoint = null;
    }

    public static interface Model
    extends Lines {
        public int getHotPointX();

        public int getHotPointY();

        public String getTabSeq();

        public ModificationResult deleteChar(int var1, int var2);

        public ModificationResult deleteRegion(int var1, int var2, int var3, int var4);

        public ModificationResult insertRegion(int var1, int var2, String[] var3);

        public ModificationResult putChars(int var1, int var2, String var3);

        public ModificationResult mergeLines(int var1);

        public ModificationResult splitLine(int var1, int var2);
    }

    public static interface Appearance {
        public boolean onBackspaceDeleteChar(ModificationResult var1);

        public boolean onBackspaceMergeLines(ModificationResult var1);

        public boolean onBackspaceTextBegin();

        public boolean onChar(ModificationResult var1);

        public boolean onDeleteChar(ModificationResult var1);

        public boolean onDeleteCharMergeLines(ModificationResult var1);

        public boolean onDeleteCharTextEnd();

        public boolean onSplitLines(ModificationResult var1);

        public boolean onTab(ModificationResult var1);
    }

    public static class ModificationResult {
        protected final boolean performed;
        protected final String stringArg;
        protected final char charArg;

        public ModificationResult(boolean performed, String stringArg, char charArg) {
            this.performed = performed;
            this.stringArg = stringArg;
            this.charArg = charArg;
        }

        public ModificationResult(boolean performed) {
            this(performed, null, '\u0000');
        }

        public ModificationResult(boolean performed, String stringArg) {
            this(performed, stringArg, '\u0000');
        }

        public ModificationResult(boolean performed, char charArg) {
            this(performed, null, charArg);
        }

        public final boolean isPerformed() {
            return this.performed;
        }

        public final String getStringArg() {
            return this.stringArg;
        }

        public final char getCharArg() {
            return this.charArg;
        }
    }
}

