/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import org.luwrain.core.Area;
import org.luwrain.core.Event;
import org.luwrain.core.NullCheck;

public abstract class AreaQuery
extends Event {
    public static final int UNIREF_AREA = 1;
    public static final int UNIREF_HOT_POINT = 2;
    public static final int URL_AREA = 3;
    public static final int URL_HOT_POINT = 4;
    public static final int CURRENT_DIR = 5;
    public static final int BEGIN_LISTENING = 6;
    public static final int BACKGROUND_SOUND = 7;
    public static final int REGION_TEXT = 8;
    private final int code;
    private boolean hasAnswer = false;

    public AreaQuery(int code) {
        this.code = code;
    }

    public final int getQueryCode() {
        return this.code;
    }

    public abstract Object getAnswer();

    public boolean hasAnswer() {
        return this.hasAnswer;
    }

    protected void answerTaken() {
        this.hasAnswer = true;
    }

    protected void secondAnswerCheck() {
        if (this.hasAnswer()) {
            throw new IllegalArgumentException("Answer may not be made twice");
        }
    }

    public static boolean ask(Area area, AreaQuery query) {
        NullCheck.notNull((Object)area, (String)"area");
        NullCheck.notNull((Object)query, (String)"query");
        return area.onAreaQuery(query) && query.hasAnswer();
    }
}

