/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import org.luwrain.core.Area;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.queries.RegionTextQuery;

final class AreaText {
    private final Area area;

    AreaText(Area area) {
        NullCheck.notNull((Object)area, (String)"area");
        this.area = area;
    }

    String get(Luwrain.AreaTextType type) {
        NullCheck.notNull((Object)((Object)type), (String)"type");
        switch (type) {
            case WORD: {
                return this.getWord();
            }
            case REGION: {
                return this.getRegion();
            }
        }
        return null;
    }

    String getWord() {
        int i;
        int x = this.area.getHotPointX();
        int y = this.area.getHotPointY();
        if (y >= this.area.getLineCount()) {
            return "";
        }
        String line = this.area.getLine(y);
        if (line == null || x >= line.length()) {
            return "";
        }
        if (!AreaText.wordChar(line.charAt(x))) {
            return "";
        }
        Object res = "";
        for (i = x; i >= 0 && AreaText.wordChar(line.charAt(i)); --i) {
            res = line.charAt(i) + (String)res;
        }
        for (i = x + 1; i < line.length() && AreaText.wordChar(line.charAt(i)); ++i) {
            res = (String)res + line.charAt(i);
        }
        return res;
    }

    private String getRegion() {
        RegionTextQuery query = new RegionTextQuery();
        if (!AreaQuery.ask(this.area, query)) {
            return null;
        }
        return query.getAnswer();
    }

    private static boolean wordChar(char c) {
        return Character.isLetter(c) || Character.isDigit(c) || c == '_' || c == '-';
    }
}

