/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.io.File;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.luwrain.app.cpanel.ControlPanelApp;
import org.luwrain.app.jobs.App;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.core.Action;
import org.luwrain.core.Area;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.AreaWrapperFactory;
import org.luwrain.core.Command;
import org.luwrain.core.Core;
import org.luwrain.core.DefaultEventResponse;
import org.luwrain.core.EmptyJobListener;
import org.luwrain.core.ExtensionsManager;
import org.luwrain.core.Hint;
import org.luwrain.core.Job;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Popup;
import org.luwrain.core.Search;
import org.luwrain.core.Sounds;
import org.luwrain.core.Speech;
import org.luwrain.core.UniRefInfo;
import org.luwrain.core.UniRefUtils;
import org.luwrain.core.events.ActionEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.core.queries.CurrentDirQuery;
import org.luwrain.cpanel.Factory;
import org.luwrain.popups.Popups;
import org.luwrain.script.Hooks;
import org.luwrain.script.core.MapScriptObject;
import org.luwrain.shell.ContextMenu;
import org.luwrain.shell.Conversations;
import org.luwrain.shell.MainMenu;

final class Commands {
    private static final int SPEECH_STEP = 5;
    private static final int VOLUME_STEP = 5;
    private static final Set<String> osCmdHistory = new HashSet<String>();

    Commands() {
    }

    static Command[] getCommands(final Core core, Conversations conversations) {
        NullCheck.notNull((Object)core, (String)"core");
        NullCheck.notNull((Object)conversations, (String)"conversations");
        Hooks hooks = new Hooks();
        return new Command[]{new Cmd("main-menu", luwrain -> {
            core.mainCoreThreadOnly();
            MainMenu mainMenu = MainMenu.newMainMenu(core.luwrain);
            if (mainMenu == null) {
                return;
            }
            core.popup(null, mainMenu, Popup.Position.LEFT, () -> mainMenu.closing.continueEventLoop(), EnumSet.of(Popup.Flags.NO_MULTIPLE_COPIES));
            if (mainMenu.closing.cancelled()) {
                return;
            }
            UniRefInfo result = mainMenu.result();
            core.uniRefProcs.open(result.getValue());
        }), new Cmd("search", luwrain -> {
            Area activeArea = core.getActiveArea(true);
            if (activeArea == null) {
                return;
            }
            if (!core.apps.setAreaWrapper(activeArea, new AreaWrapperFactory(){

                @Override
                public Area createAreaWrapper(Area areaToWrap, AreaWrapperFactory.Disabling disabling) {
                    return new Search(areaToWrap, core, disabling);
                }
            })) {
                core.soundManager.playIcon(Sounds.INACCESSIBLE);
            }
            core.onNewAreasLayout();
        }), new Cmd("ok", luwrain -> core.enqueueEvent(new SystemEvent(SystemEvent.Code.OK))), new Cmd("cancel", luwrain -> core.enqueueEvent(new SystemEvent(SystemEvent.Code.CANCEL))), new Cmd("close", luwrain -> core.enqueueEvent(new SystemEvent(SystemEvent.Code.CLOSE))), new Cmd("gc", luwrain -> System.gc()), new Cmd("save", luwrain -> core.enqueueEvent(new SystemEvent(SystemEvent.Code.SAVE))), new Cmd("open", luwrain -> {
            File res = conversations.open();
            if (res != null) {
                core.fileTypes.launch(core, new String[]{res.getAbsolutePath()});
            }
        }), new Cmd("announce", luwrain -> core.announceActiveArea()), new Cmd("refresh", luwrain -> core.enqueueEvent(new SystemEvent(SystemEvent.Code.REFRESH))), new Cmd("announce-line", luwrain -> {
            Area area = core.getActiveArea(true);
            if (area == null) {
                return;
            }
            if (area.onSystemEvent(new SystemEvent(SystemEvent.Code.ANNOUNCE_LINE))) {
                return;
            }
            int hotPointY = area.getHotPointY();
            if (hotPointY >= area.getLineCount()) {
                core.eventNotProcessedMessage();
                return;
            }
            String line = area.getLine(hotPointY);
            if (line == null) {
                core.eventNotProcessedMessage();
                return;
            }
            if (!line.trim().isEmpty()) {
                core.speech.speak(line, 0, 0);
            } else {
                core.luwrain.setEventResponse(DefaultEventResponse.hint(Hint.EMPTY_LINE));
            }
            core.announcement = null;
        }), new Cmd("region-point", luwrain -> {
            Area area = core.getActiveArea(true);
            if (area == null) {
                return;
            }
            if (!area.onSystemEvent(new SystemEvent(SystemEvent.Code.REGION_POINT))) {
                core.eventNotProcessedMessage();
                return;
            }
            HashMap<String, Object> arg = new HashMap<String, Object>();
            arg.put("x", area.getHotPointX());
            arg.put("y", area.getHotPointY());
            MapScriptObject argObj = new MapScriptObject(arg);
            if (!Hooks.chainOfResponsibilityNoExc(core.luwrain, "luwrain.area.region.point.set", new Object[]{argObj})) {
                core.eventNotProcessedMessage();
            }
        }), new Cmd("copy", luwrain -> {
            Area area = core.getActiveArea(true);
            if (area == null) {
                return;
            }
            if (area.onSystemEvent(new SystemEvent(SystemEvent.Code.CLIPBOARD_COPY))) {
                core.soundManager.playIcon(Sounds.COPIED);
            } else {
                core.eventNotProcessedMessage();
            }
        }), new Cmd("copy-all", luwrain -> {
            Area area = core.getActiveArea(true);
            if (area == null) {
                return;
            }
            if (!area.onSystemEvent(new SystemEvent(SystemEvent.Code.CLIPBOARD_COPY_ALL))) {
                core.eventNotProcessedMessage();
                return;
            }
            HashMap<String, Object> arg = new HashMap<String, Object>();
            MapScriptObject argObj = new MapScriptObject(arg);
            if (!Hooks.chainOfResponsibilityNoExc(core.luwrain, "luwrain.clipboard.copy.all", new Object[]{argObj})) {
                core.eventNotProcessedMessage();
            }
        }), new Cmd("cut", luwrain -> {
            Area area = core.getActiveArea(true);
            if (area == null) {
                return;
            }
            if (area.onSystemEvent(new SystemEvent(SystemEvent.Code.CLIPBOARD_CUT))) {
                core.soundManager.playIcon(Sounds.CUT);
            } else {
                core.eventNotProcessedMessage();
            }
        }), new Cmd("clear-region", luwrain -> {
            Area area = core.getActiveArea(true);
            if (area == null) {
                return;
            }
            if (area.onSystemEvent(new SystemEvent(SystemEvent.Code.CLEAR_REGION))) {
                core.soundManager.playIcon(Sounds.DELETED);
            } else {
                core.eventNotProcessedMessage();
            }
        }), new Cmd("paste", luwrain -> {
            if (luwrain.getClipboard().isEmpty()) {
                core.eventNotProcessedMessage();
                return;
            }
            Area area = core.getActiveArea(true);
            if (area == null) {
                return;
            }
            if (area.onSystemEvent(new SystemEvent(SystemEvent.Code.CLIPBOARD_PASTE))) {
                core.soundManager.playIcon(Sounds.PASTE);
            } else {
                core.eventNotProcessedMessage();
            }
        }), new Cmd("clear", luwrain -> {
            Area area = core.getActiveArea(true);
            if (area == null) {
                return;
            }
            if (!area.onSystemEvent(new SystemEvent(SystemEvent.Code.CLEAR))) {
                core.eventNotProcessedMessage();
                return;
            }
            HashMap<String, Object> arg = new HashMap<String, Object>();
            if (!Hooks.chainOfResponsibilityNoExc(core.luwrain, "luwrain.area.clear", new Object[]{new MapScriptObject(arg)})) {
                core.eventNotProcessedMessage();
            }
        }), new Cmd("help", luwrain -> core.enqueueEvent(new SystemEvent(SystemEvent.Code.HELP))), new Cmd("switch-next-app", luwrain -> core.onSwitchNextAppCommand()), new Cmd("switch-next-area", luwrain -> core.onSwitchNextAreaCommand()), new Cmd("font-size-inc", luwrain -> core.fontSizeInc()), new Cmd("font-size-dec", luwrain -> core.fontSizeDec()), new Cmd("jobs", luwrain -> core.launchApp(new App(core.jobs))), new Cmd("calc", luwrain -> core.launchApp(new org.luwrain.app.calc.App())), new Cmd("console", luwrain -> core.launchApp(new org.luwrain.app.console.App())), new Cmd("context-menu", luwrain -> {
            Area activeArea = core.getActiveArea(true);
            if (activeArea == null) {
                return;
            }
            AtomicReference act = new AtomicReference();
            core.unsafeAreaOperation(() -> act.set(activeArea.getAreaActions()));
            if (act.get() == null || ((Action[])act.get()).length == 0) {
                core.areaInaccessibleMessage();
                return;
            }
            ContextMenu menu = new ContextMenu(core.luwrain, (Action[])act.get());
            core.popup(null, menu, Popup.Position.RIGHT, () -> menu.isPopupActive(), EnumSet.of(Popup.Flags.NO_MULTIPLE_COPIES));
            if (menu.wasCancelled()) {
                return;
            }
            Object selected = menu.selected();
            if (selected == null || !(selected instanceof Action)) {
                return;
            }
            AtomicBoolean r = new AtomicBoolean(false);
            core.unsafeAreaOperation(() -> r.set(activeArea.onSystemEvent(new ActionEvent((Action)selected))));
            if (!r.get()) {
                core.areaInaccessibleMessage();
            }
        }), new Command(){

            @Override
            public String getName() {
                return "copy-uri-area";
            }

            @Override
            public void onCommand(Luwrain luwrain) {
                NullCheck.notNull((Object)luwrain, (String)"luwrain");
                String res = luwrain.getActiveAreaAttr(Luwrain.AreaAttr.UNIREF);
                if (res == null || res.isEmpty()) {
                    core.eventNotProcessedMessage();
                    return;
                }
                UniRefInfo uniRefInfo = core.uniRefProcs.getInfo(res);
                if (uniRefInfo == null) {
                    core.eventNotProcessedMessage();
                    return;
                }
                UniRefUtils.defaultAnnouncement(new DefaultControlContext(luwrain), uniRefInfo, Sounds.OK, null);
                core.getClipboard().set(res);
            }
        }, new Command(){

            @Override
            public String getName() {
                return "copy-uri-hot-point";
            }

            @Override
            public void onCommand(Luwrain luwrain) {
                NullCheck.notNull((Object)luwrain, (String)"luwrain");
                String res = luwrain.getActiveAreaAttr(Luwrain.AreaAttr.UNIREF_UNDER_HOT_POINT);
                if (res == null || res.isEmpty()) {
                    core.eventNotProcessedMessage();
                    return;
                }
                UniRefInfo uniRefInfo = core.uniRefProcs.getInfo(res);
                if (uniRefInfo == null) {
                    core.eventNotProcessedMessage();
                    return;
                }
                UniRefUtils.defaultAnnouncement(new DefaultControlContext(luwrain), uniRefInfo, Sounds.OK, null);
                core.getClipboard().set(res);
            }
        }, new Command(){

            @Override
            public String getName() {
                return "copy-url-area";
            }

            @Override
            public void onCommand(Luwrain luwrain) {
                NullCheck.notNull((Object)luwrain, (String)"luwrain");
                String res = luwrain.getActiveAreaAttr(Luwrain.AreaAttr.URL);
                if (res == null || res.isEmpty()) {
                    core.eventNotProcessedMessage();
                    return;
                }
                core.message(luwrain.getSpeakableText(res, Luwrain.SpeakableTextType.PROGRAMMING), Luwrain.MessageType.OK);
                core.getClipboard().set(res);
            }
        }, new Command(){

            @Override
            public String getName() {
                return "copy-url-hot-point";
            }

            @Override
            public void onCommand(Luwrain luwrain) {
                NullCheck.notNull((Object)luwrain, (String)"luwrain");
                String res = luwrain.getActiveAreaAttr(Luwrain.AreaAttr.URL_UNDER_HOT_POINT);
                if (res == null || res.isEmpty()) {
                    core.eventNotProcessedMessage();
                    return;
                }
                core.message(luwrain.getSpeakableText(res, Luwrain.SpeakableTextType.PROGRAMMING), Luwrain.MessageType.OK);
                core.getClipboard().set(res);
            }
        }, new Command(){

            @Override
            public String getName() {
                return "speech-pitch-inc";
            }

            @Override
            public void onCommand(Luwrain luwrain) {
                Speech speech = core.speech;
                speech.setPitch(speech.getPitch() + 5);
                luwrain.message("\u0412\u044b\u0441\u043e\u0442\u0430 \u0440\u0435\u0447\u0438 " + speech.getPitch());
            }
        }, new Command(){

            @Override
            public String getName() {
                return "speech-pitch-dec";
            }

            @Override
            public void onCommand(Luwrain luwrain) {
                Speech speech = core.speech;
                speech.setPitch(speech.getPitch() - 5);
                luwrain.message("\u0412\u044b\u0441\u043e\u0442\u0430 \u0440\u0435\u0447\u0438 " + speech.getPitch());
            }
        }, new Command(){

            @Override
            public String getName() {
                return "speech-speed-inc";
            }

            @Override
            public void onCommand(Luwrain luwrain) {
                Speech speech = core.speech;
                speech.setRate(speech.getRate() - 5);
                luwrain.message("\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u0440\u0435\u0447\u0438 " + (100 - speech.getRate()));
            }
        }, new Command(){

            @Override
            public String getName() {
                return "speech-speed-dec";
            }

            @Override
            public void onCommand(Luwrain luwrain) {
                Speech speech = core.speech;
                speech.setRate(speech.getRate() + 5);
                luwrain.message("\u0421\u043a\u043e\u0440\u043e\u0441\u0442\u044c \u0440\u0435\u0447\u0438 " + (100 - speech.getRate()));
            }
        }, new Command(){

            @Override
            public String getName() {
                return "listen";
            }

            @Override
            public void onCommand(Luwrain luwrain) {
                core.startAreaListening();
            }
        }, new Command(){

            @Override
            public String getName() {
                return "say-current-word";
            }

            @Override
            public void onCommand(Luwrain luwrain) {
                NullCheck.notNull((Object)luwrain, (String)"luwrain");
                String word = luwrain.getActiveAreaText(Luwrain.AreaTextType.WORD, true);
                if (word != null && !word.trim().isEmpty()) {
                    core.message(word, Luwrain.MessageType.REGULAR);
                }
            }
        }, new Command(){

            @Override
            public String getName() {
                return "properties";
            }

            @Override
            public void onCommand(Luwrain luwrain) {
                Area area = core.getActiveArea(true);
                if (area == null) {
                    return;
                }
                if (!area.onSystemEvent(new SystemEvent(SystemEvent.Code.PROPERTIES))) {
                    core.eventNotProcessedMessage();
                }
            }
        }, new Cmd("run", luwrain -> {
            String cmd = Popups.editWithHistory(core.luwrain, luwrain.i18n().getStaticStr("RunPopupName"), luwrain.i18n().getStaticStr("RunPopupPrefix"), "", osCmdHistory);
            if (cmd == null || cmd.trim().isEmpty()) {
                return;
            }
            Area area = core.tiles.getActiveArea();
            if (area != null) {
                CurrentDirQuery query = new CurrentDirQuery();
                if (AreaQuery.ask(area, query)) {
                    String dir = query.getAnswer();
                } else {
                    String dir = "";
                }
            } else {
                String dir = "";
            }
            luwrain.newJob("sys", new String[]{cmd.trim()}, "", EnumSet.noneOf(Luwrain.JobFlags.class), new EmptyJobListener(){

                @Override
                public void onStatusChange(Job instance) {
                    if (instance.getStatus() != Job.Status.FINISHED) {
                        return;
                    }
                    List<String> output = instance.getInfo("main");
                    String name = instance.getInstanceName();
                    luwrain.runUiSafely(() -> {
                        if (output.size() >= 2) {
                            Popups.fixedList(luwrain, name, output.toArray(new String[output.size()]));
                            return;
                        }
                        if (output.isEmpty() || output.size() == 1 && ((String)output.get(0)).trim().isEmpty()) {
                            luwrain.message(name, instance.isFinishedSuccessfully() ? Luwrain.MessageType.DONE : Luwrain.MessageType.ERROR);
                        } else {
                            luwrain.message(((String)output.get(0)).trim(), instance.isFinishedSuccessfully() ? Luwrain.MessageType.DONE : Luwrain.MessageType.ERROR);
                        }
                    });
                }
            });
        })};
    }

    static Command[] getNonStandaloneCommands(Core core, Conversations conversations) {
        return new Command[]{new Cmd("control-panel", luwrain -> {
            ArrayList<Factory> res = new ArrayList<Factory>();
            for (ExtensionsManager.Entry e : core.extensions.extensions) {
                for (Factory f : e.ext.getControlPanelFactories(e.luwrain)) {
                    if (f == null) continue;
                    res.add(f);
                }
            }
            ControlPanelApp app = new ControlPanelApp(res.toArray(new Factory[res.size()]));
            core.launchApp(app);
        })};
    }

    private static final class Cmd
    implements Command {
        private final String name;
        private final Handler handler;

        Cmd(String name, Handler handler) {
            NullCheck.notEmpty((Object)name, (String)"name");
            NullCheck.notNull((Object)handler, (String)"handler");
            this.name = name;
            this.handler = handler;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void onCommand(Luwrain luwrain) {
            this.handler.onCommand(luwrain);
        }
    }

    private static interface Handler {
        public void onCommand(Luwrain var1);
    }
}

