/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.luwrain.core.ContentTypes;
import org.luwrain.core.NullCheck;

final class FileContentType {
    private final Map<String, String> contentTypes = new HashMap<String, String>();

    FileContentType() {
        this.contentTypes.put(".*\\.dat$", ContentTypes.DATA_BINARY_DEFAULT);
        this.contentTypes.put(".*\\.raw$", ContentTypes.DATA_BINARY_DEFAULT);
        this.contentTypes.put(".*\\.txt$", ContentTypes.TEXT_PLAIN_DEFAULT);
        this.contentTypes.put(".*\\.htm$", "text/html");
        this.contentTypes.put(".*\\.html$", "text/html");
        this.contentTypes.put(".*\\.doc$", "application/msword");
        this.contentTypes.put(".*\\.docx$", "application/vnd.openxmlformats-officedocument.wordprocessingml.document");
        this.contentTypes.put(".*\\.xlsx$", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        this.contentTypes.put(".*\\.wav$", ContentTypes.SOUND_WAVE_DEFAULT);
        this.contentTypes.put(".*\\.wave$", ContentTypes.SOUND_WAVE_DEFAULT);
        this.contentTypes.put(".*\\.mp3$", ContentTypes.SOUND_MP3_DEFAULT);
        this.contentTypes.put(".*\\.xhtml$", "application/xhtml");
        this.contentTypes.put(".*\\.xhtm$", "application/xhtml");
        this.contentTypes.put(".*\\.pdf$", "application/pdf");
        this.contentTypes.put(".*\\.ps$", "application/postscript");
        this.contentTypes.put(".*\\.zip$", "application/zip");
        this.contentTypes.put(".*\\.fb2$", "application/fb2");
    }

    String suggestContentType(File file, ContentTypes.ExpectedType expectedType) {
        NullCheck.notNull((Object)file, (String)"file");
        NullCheck.notNull((Object)((Object)expectedType), (String)"expectedType");
        if (file.getAbsolutePath().isEmpty()) {
            return "";
        }
        String res = this.find(file.getName());
        if (!res.isEmpty()) {
            return res;
        }
        switch (expectedType) {
            case TEXT: {
                return ContentTypes.TEXT_PLAIN_DEFAULT;
            }
            case AUDIO: {
                return ContentTypes.SOUND_MP3_DEFAULT;
            }
        }
        return ContentTypes.DATA_BINARY_DEFAULT;
    }

    String suggestContentType(URL url, ContentTypes.ExpectedType expectedType) {
        NullCheck.notNull((Object)url, (String)"url");
        NullCheck.notNull((Object)((Object)expectedType), (String)"expectedType");
        String res = this.find(url.getFile());
        if (!res.isEmpty()) {
            return res;
        }
        switch (expectedType) {
            case TEXT: {
                return ContentTypes.TEXT_PLAIN_DEFAULT;
            }
            case AUDIO: {
                return ContentTypes.SOUND_MP3_DEFAULT;
            }
        }
        return ContentTypes.DATA_BINARY_DEFAULT;
    }

    private String find(String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return "";
        }
        for (Map.Entry<String, String> e : this.contentTypes.entrySet()) {
            if (!FileContentType.match(e.getKey(), fileName)) continue;
            return e.getValue();
        }
        return "";
    }

    private static boolean match(String pattern, String line) {
        NullCheck.notEmpty((Object)pattern, (String)"pattern");
        NullCheck.notNull((Object)line, (String)"line");
        Pattern pat = Pattern.compile(pattern, 2);
        Matcher matcher = pat.matcher(line);
        return matcher.find();
    }
}

