/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import org.luwrain.core.Application;
import org.luwrain.core.Area;
import org.luwrain.core.AreaLayout;
import org.luwrain.core.Base;
import org.luwrain.core.LaunchedAppPopups;
import org.luwrain.core.NullCheck;
import org.luwrain.core.OpenedArea;
import org.luwrain.core.events.SystemEvent;

final class LaunchedApp
extends LaunchedAppPopups {
    private static final String LOG_COMPONENT = "core";
    final Application app;
    AreaLayout.Type layoutType;
    Area[] areas;
    OpenedArea[] areaWrappings;
    int activeAreaIndex = 0;
    Application activeAppBeforeLaunch;

    LaunchedApp(Application app) {
        NullCheck.notNull((Object)app, (String)"app");
        this.app = app;
    }

    boolean init() {
        AreaLayout layout = this.getValidAreaLayout();
        this.layoutType = layout.layoutType;
        this.areas = layout.getAreas();
        if (this.areas == null) {
            Base.error("application " + this.app.getClass().getName() + " has area layout without areas");
            return false;
        }
        this.areaWrappings = new OpenedArea[this.areas.length];
        for (int i = 0; i < this.areas.length; ++i) {
            if (this.areas[i] == null) {
                Base.error("application " + this.app.getClass().getName() + " has a null area");
                return false;
            }
            this.areaWrappings[i] = new OpenedArea(this.areas[i]);
        }
        return true;
    }

    boolean refreshAreaLayout() {
        int i;
        Area previouslyActiveArea = this.areas[this.activeAreaIndex];
        AreaLayout newLayout = this.getValidAreaLayout();
        AreaLayout.Type newLayoutType = newLayout.layoutType;
        Area[] newAreas = newLayout.getAreas();
        if (newAreas == null) {
            Base.error("application " + this.app.getClass().getName() + " has area layout without areas");
            return false;
        }
        OpenedArea[] newAreaWrappings = new OpenedArea[newAreas.length];
        for (i = 0; i < newAreas.length; ++i) {
            if (newAreas[i] == null) {
                Base.error("application " + this.app.getClass().getName() + " has a null area");
                return false;
            }
            newAreaWrappings[i] = new OpenedArea(newAreas[i]);
        }
        this.layoutType = newLayoutType;
        this.areas = newAreas;
        this.areaWrappings = newAreaWrappings;
        this.activeAreaIndex = -1;
        for (i = 0; i < this.areas.length; ++i) {
            if (previouslyActiveArea != this.areas[i]) continue;
            this.activeAreaIndex = i;
        }
        if (this.activeAreaIndex < 0 || this.activeAreaIndex > this.areas.length) {
            this.activeAreaIndex = 0;
        }
        return true;
    }

    private AreaLayout getValidAreaLayout() {
        AreaLayout layout;
        try {
            layout = this.app.getAreaLayout();
        }
        catch (Throwable e) {
            Base.error(e, "application " + this.app.getClass().getName() + " has thrown an exception on getAreaLayout()");
            return null;
        }
        if (layout == null) {
            Base.error("application " + this.app.getClass().getName() + " has returned an empty area layout");
            return null;
        }
        if (!layout.isValid()) {
            Base.error("application " + this.app.getClass().getName() + " has returned an invalid area layout");
            return null;
        }
        return layout;
    }

    void removeReviewWrappers() {
        if (this.areaWrappings != null) {
            for (OpenedArea w : this.areaWrappings) {
                w.wrapper = null;
            }
        }
    }

    boolean setActiveArea(Area area) {
        int index;
        NullCheck.notNull((Object)area, (String)"area");
        if (this.areaWrappings == null) {
            return false;
        }
        for (index = 0; index < this.areaWrappings.length && !this.areaWrappings[index].hasArea(area); ++index) {
        }
        if (index >= this.areaWrappings.length) {
            return false;
        }
        this.activeAreaIndex = index;
        return true;
    }

    Area getFrontActiveArea() {
        if (this.activeAreaIndex < 0 || this.areaWrappings == null) {
            return null;
        }
        return this.areaWrappings[this.activeAreaIndex].getFrontArea();
    }

    @Override
    public Area getCorrespondingFrontArea(Area area) {
        NullCheck.notNull((Object)area, (String)"area");
        for (OpenedArea w : this.areaWrappings) {
            if (!w.hasArea(area)) continue;
            return w.getFrontArea();
        }
        return super.getCorrespondingFrontArea(area);
    }

    @Override
    public OpenedArea getAreaWrapping(Area area) {
        NullCheck.notNull((Object)area, (String)"area");
        for (OpenedArea w : this.areaWrappings) {
            if (!w.hasArea(area)) continue;
            return w;
        }
        return super.getAreaWrapping(area);
    }

    AreaLayout getFrontAreaLayout() {
        Area[] a = new Area[this.areas.length];
        for (int i = 0; i < this.areaWrappings.length; ++i) {
            a[i] = this.areaWrappings[i].getFrontArea();
        }
        return new AreaLayout(this.layoutType, a);
    }

    @Override
    void sendBroadcastEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        for (OpenedArea w : this.areaWrappings) {
            w.getFrontArea().onSystemEvent(event);
        }
    }
}

