/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.util.ArrayList;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Registry;
import org.luwrain.core.RegistryProxy;

public interface Settings {
    public static final String UI_PATH = "/org/luwrain/ui";
    public static final String HELP_SECTIONS_PATH = "/org/luwrain/help/sections";
    public static final String NETWORK_PATH = "/org/luwrain/network";
    public static final String DATETIME_PATH = "/org/luwrain/date-time";
    public static final String FILE_TYPES_APP_INFO_PATH = "/org/luwrain/file-types/app-info";
    public static final String FILE_TYPES_PATH = "/org/luwrain/file-types";
    public static final String GLOBAL_KEYS_PATH = "/org/luwrain/global-keys";
    public static final String SPEECH_PATH = "/org/luwrain/speech";
    public static final String BRAILLE_PATH = "/org/luwrain/braille";
    public static final String CURRENT_SOUND_SCHEME_PATH = "/org/luwrain/sounds/scheme";
    public static final String INTERACTION_PARAMS_PATH = "/org/luwrain/interaction";
    public static final String I18N_PATH = "/org/luwrain/i18n";
    public static final String PERSONAL_INFO_PATH = "/org/luwrain/personal";
    public static final String BACKGROUND_SOUNDS_PATH = "/org/luwrain/sounds/background";
    public static final String DESKTOP_UNIREFS_PATH = "/org/luwrain/desktop/unirefs";

    public static PersonalInfo createPersonalInfo(Registry registry) {
        NullCheck.notNull((Object)registry, (String)"registry");
        return RegistryProxy.create(registry, PERSONAL_INFO_PATH, PersonalInfo.class);
    }

    public static InteractionParams createInteractionParams(Registry registry) {
        return RegistryProxy.create(registry, INTERACTION_PARAMS_PATH, InteractionParams.class);
    }

    public static HotKey createHotKey(Registry registry, String path) {
        return RegistryProxy.create(registry, path, HotKey.class);
    }

    public static MainMenuSection createMainMenuSection(Registry registry, String path) {
        return RegistryProxy.create(registry, path, MainMenuSection.class);
    }

    public static SoundScheme createCurrentSoundScheme(Registry registry) {
        return RegistryProxy.create(registry, CURRENT_SOUND_SCHEME_PATH, SoundScheme.class);
    }

    public static BackgroundSounds createBackgroundSounds(Registry registry) {
        NullCheck.notNull((Object)registry, (String)"registry");
        return RegistryProxy.create(registry, BACKGROUND_SOUNDS_PATH, BackgroundSounds.class);
    }

    public static Braille createBraille(Registry registry) {
        NullCheck.notNull((Object)registry, (String)"registry");
        return RegistryProxy.create(registry, BRAILLE_PATH, Braille.class);
    }

    public static SpeechParams createSpeechParams(Registry registry) {
        return RegistryProxy.create(registry, SPEECH_PATH, SpeechParams.class);
    }

    public static I18n createI18n(Registry registry) {
        NullCheck.notNull((Object)registry, (String)"registry");
        return RegistryProxy.create(registry, I18N_PATH, I18n.class);
    }

    public static String[] getI18nCharsets(Registry registry) {
        NullCheck.notNull((Object)registry, (String)"registry");
        String value = Settings.createI18n(registry).getCharsets("");
        if (value.trim().isEmpty()) {
            return new String[0];
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String s : value.split(":", -1)) {
            if (s.trim().isEmpty()) continue;
            res.add(s.trim());
        }
        return res.toArray(new String[res.size()]);
    }

    public static Network createNetwork(Registry registry) {
        NullCheck.notNull((Object)registry, (String)"registry");
        return RegistryProxy.create(registry, NETWORK_PATH, Network.class);
    }

    public static DateTime createDateTime(Registry registry) {
        NullCheck.notNull((Object)registry, (String)"registry");
        return RegistryProxy.create(registry, DATETIME_PATH, DateTime.class);
    }

    public static interface PersonalInfo {
        public String getFullName(String var1);

        public String getDefaultMailAddress(String var1);

        public String getSignature(String var1);

        public void setFullName(String var1);

        public void setDefaultMailAddress(String var1);

        public void setSignature(String var1);
    }

    public static interface InteractionParams {
        public int getWindowLeft(int var1);

        public int getWindowTop(int var1);

        public int getWindowWidth(int var1);

        public int getWindowHeight(int var1);

        public int getMarginLeft(int var1);

        public int getMarginTop(int var1);

        public int getMarginRight(int var1);

        public int getMarginBottom(int var1);

        public int getFontColorRed(int var1);

        public int getFontColorGreen(int var1);

        public int getFontColorBlue(int var1);

        public int getFont2ColorRed(int var1);

        public int getFont2ColorGreen(int var1);

        public int getFont2ColorBlue(int var1);

        public int getBkgColorRed(int var1);

        public int getBkgColorGreen(int var1);

        public int getBkgColorBlue(int var1);

        public int getSplitterColorRed(int var1);

        public int getSplitterColorGreen(int var1);

        public int getSplitterColorBlue(int var1);

        public int getInitialFontSize(int var1);

        public String getFontName(String var1);

        public void setWindowLeft(int var1);

        public void setWindowTop(int var1);

        public void setWindowWidth(int var1);

        public void setWindowHeight(int var1);

        public void setMarginLeft(int var1);

        public void setMarginTop(int var1);

        public void setMarginRight(int var1);

        public void setMarginBottom(int var1);

        public void setFontColorRed(int var1);

        public void setFontColorGreen(int var1);

        public void setFontColorBlue(int var1);

        public void setFont2ColorRed(int var1);

        public void setFont2ColorGreen(int var1);

        public void setFont2ColorBlue(int var1);

        public void setBkgColorRed(int var1);

        public void setBkgColorGreen(int var1);

        public void setBkgColorBlue(int var1);

        public void setSplitterColorRed(int var1);

        public void setSplitterColorGreen(int var1);

        public void setSplitterColorBlue(int var1);

        public void setInitialFontSize(int var1);

        public void setFontName(String var1);
    }

    public static interface HotKey {
        public String getSpecial(String var1);

        public String getCharacter(String var1);

        public boolean getWithControl(boolean var1);

        public boolean getWithShift(boolean var1);

        public boolean getWithAlt(boolean var1);

        public String getKeys(String var1);

        public void setKeys(String var1);
    }

    public static interface MainMenuSection {
        public String getTitle(String var1);

        public void setTitle(String var1);

        public String getUniRefs(String var1);

        public void setUniRefs(String var1);
    }

    public static interface SoundScheme {
        public String getAlert(String var1);

        public String getAnnouncement(String var1);

        public String getAttention(String var1);

        public String getBlocked(String var1);

        public String getCancel(String var1);

        public String getChatMessage(String var1);

        public String getCollapsed(String var1);

        public String getCommanderLocation(String var1);

        public String getCopied(String var1);

        public String getCut(String var1);

        public String getDeleted(String var1);

        public String getDesktopItem(String var1);

        public String getDocSection(String var1);

        public String getDone(String var1);

        public String getEmptyLine(String var1);

        public String getEndOfLine(String var1);

        public String getError(String var1);

        public String getExpanded(String var1);

        public String getEventNotProcessed(String var1);

        public String getFatal(String var1);

        public String getGeneralTime(String var1);

        public String getIntroApp(String var1);

        public String getIntroPopup(String var1);

        public String getIntroRegular(String var1);

        public String getListItem(String var1);

        public String getMainMenuEmptyLine(String var1);

        public String getMainMenuItem(String var1);

        public String getMainMenu(String var1);

        public String getMessage(String var1);

        public String getNoApplications(String var1);

        public String getNoContent(String var1);

        public String getNoItemsAbove(String var1);

        public String getNoItemsBelow(String var1);

        public String getNoLinesAbove(String var1);

        public String getNoLinesBelow(String var1);

        public String getOk(String var1);

        public String getParagraph(String var1);

        public String getPaste(String var1);

        public String getRegionPoint(String var1);

        public String getSearch(String var1);

        public String getSelected(String var1);

        public String getShutdown(String var1);

        public String getStartup(String var1);

        public String getTermBell(String var1);

        public String getUnselected(String var1);

        public String getTableCell(String var1);

        public void setAlert(String var1);

        public void setAnnouncement(String var1);

        public void setAttention(String var1);

        public void setBlocked(String var1);

        public void setCancel(String var1);

        public void setChatMessage(String var1);

        public void setCollapsed(String var1);

        public void setCommanderLocation(String var1);

        public void setCopied(String var1);

        public void setCut(String var1);

        public void setDeleted(String var1);

        public void setDesktopItem(String var1);

        public void setDocSection(String var1);

        public void setDone(String var1);

        public void setEmptyLine(String var1);

        public void setEndOfLine(String var1);

        public void setError(String var1);

        public void setEventNotProcessed(String var1);

        public void setExpanded(String var1);

        public void setFatal(String var1);

        public void setGeneralTime(String var1);

        public void setIntroApp(String var1);

        public void setIntroPopup(String var1);

        public void setIntroRegular(String var1);

        public void setListItem(String var1);

        public void setMainMenuEmptyLine(String var1);

        public void setMainMenuItem(String var1);

        public void setMainMenu(String var1);

        public void setMessage(String var1);

        public void setNoApplications(String var1);

        public void setNoContent(String var1);

        public void setNoItemsAbove(String var1);

        public void setNoItemsBelow(String var1);

        public void setNoLinesAbove(String var1);

        public void setNoLinesBelow(String var1);

        public void setOk(String var1);

        public void setParagraph(String var1);

        public void setPaste(String var1);

        public void setRegionPoint(String var1);

        public void setSearch(String var1);

        public void setSelected(String var1);

        public void setShutdown(String var1);

        public void setStartup(String var1);

        public void setTermBell(String var1);

        public void setTableCell(String var1);

        public void setUnselected(String var1);
    }

    public static interface BackgroundSounds {
        public String getStarting(String var1);

        public String getPopup(String var1);

        public String getFetching(String var1);

        public String getMainMenu(String var1);

        public String getWifi(String var1);

        public String getSearch(String var1);
    }

    public static interface Braille {
        public boolean getEnabled(boolean var1);

        public void setEnabled(boolean var1);
    }

    public static interface SpeechParams {
        public String getMainEngineName(String var1);

        public String getMainEngineParams(String var1);

        public String getListeningEngineName(String var1);

        public String getListeningEngineParams(String var1);

        public int getListeningPitch(int var1);

        public int getListeningRate(int var1);

        public int getPitch(int var1);

        public int getRate(int var1);

        public void setMainEngineName(String var1);

        public void setMainEngineParams(String var1);

        public void setListeningEngineName(String var1);

        public void setListeningEngineParams(String var1);

        public void setListeningPitch(int var1);

        public void setListeningRate(int var1);

        public void setPitch(int var1);

        public void setRate(int var1);
    }

    public static interface I18n {
        public String getCharsets(String var1);

        public void setCharsets(String var1);
    }

    public static interface Network {
        public String getHttpProxyHost(String var1);

        public String getHttpProxyPort(String var1);

        public String getHttpProxyUser(String var1);

        public String getHttpProxyPassword(String var1);

        public String getSocksProxyHost(String var1);

        public String getSocksProxyPort(String var1);

        public void setHttpProxyHost(String var1);

        public void setHttpProxyPort(String var1);

        public void setHttpProxyLogin(String var1);

        public void setHttpProxyPassword(String var1);

        public void setSocksHost(String var1);

        public void setSocksPort(String var1);
    }

    public static interface DateTime {
        public String getTimeZone(String var1);

        public void setTimeZone(String var1);
    }
}

