/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.luwrain.core.NullCheck;

final class TempFiles {
    private static final Logger log = LogManager.getLogger();
    private static final String ENV_TMP_DIR = System.getenv("TMPDIR");
    private static final String PROP_TMP_DIR = System.getProperty("java.io.tmpdir");
    private static final String PROP_USER_HOME = System.getProperty("user.home");
    private Path tmpDir = null;

    TempFiles() {
    }

    void init() {
        if (this.tmpDir != null) {
            return;
        }
        try {
            if (ENV_TMP_DIR != null && !ENV_TMP_DIR.trim().isEmpty() && new File(ENV_TMP_DIR).exists()) {
                log.trace("Using the value from $TMPDIR for LUWRAIN temporary directory, $TMPDIR=" + ENV_TMP_DIR);
                this.tmpDir = Files.createTempDirectory(Paths.get(ENV_TMP_DIR, new String[0]), ".luwrain-", new FileAttribute[0]);
            } else if (PROP_TMP_DIR != null && !PROP_TMP_DIR.trim().isEmpty() && new File(PROP_TMP_DIR).exists()) {
                log.trace("Using the value from the java.io.tmpdir system property for LUWRAIN temporary directory, java.io.tmpdir=" + PROP_TMP_DIR);
                this.tmpDir = Files.createTempDirectory(Paths.get(PROP_TMP_DIR, new String[0]), ".luwrain-", new FileAttribute[0]);
            } else {
                log.warn("Using the value from user.home system property for LUWRAIN temporary directory, user.home=" + PROP_USER_HOME);
                this.tmpDir = Files.createTempDirectory(Paths.get(PROP_USER_HOME, new String[0]), ".luwrain-", new FileAttribute[0]);
            }
            this.tmpDir.toFile().deleteOnExit();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    File createTempFile(String prefix) {
        NullCheck.notNull((Object)prefix, (String)"prefix");
        this.init();
        try {
            Path res = Files.createTempFile(this.tmpDir, prefix + "-", ".tmp", new FileAttribute[0]);
            log.trace("Created temporary file " + res.toString());
            res.toFile().deleteOnExit();
            return res.toFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

