/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import org.luwrain.core.Area;
import org.luwrain.core.Interaction;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Popup;
import org.luwrain.core.Tile;
import org.luwrain.core.Tiles;
import org.luwrain.core.TilesManager;

final class WindowManager {
    private static final int MIN_RANGE_HORIZONTAL = 5;
    private static final int MIN_RANGE_VERTICAL = 2;
    private static final int MAX_TOP_BOTTOM_POPUP_HEIGHT = 7;
    private final Interaction interaction;
    private final TilesManager screenContentManager;
    private Object[] visibleObjs = null;

    WindowManager(Interaction interaction, TilesManager tilesManager) {
        NullCheck.notNull((Object)interaction, (String)"interace");
        NullCheck.notNull((Object)tilesManager, (String)"tilesManager");
        this.interaction = interaction;
        this.screenContentManager = tilesManager;
    }

    void redraw() {
        Tiles windows = this.screenContentManager.getWindows();
        if (windows == null) {
            return;
        }
        this.interaction.startDrawSession();
        this.interaction.clearRect(0, 1, this.interaction.getWidthInCharacters() - 1, this.interaction.getHeightInCharacters() - 1);
        this.interaction.setHotPoint(-1, -1);
        this.calculateGeom(this.interaction.getWidthInCharacters(), this.interaction.getHeightInCharacters(), windows);
        this.visibleObjs = windows.getObjects();
        for (int i = 0; i < this.visibleObjs.length; ++i) {
            Tile win = (Tile)this.visibleObjs[i];
            if (win == null || win.area == null) continue;
            this.drawWindow(win);
        }
        this.interaction.endDrawSession();
    }

    void redrawArea(Area area) {
        if (this.visibleObjs == null || this.visibleObjs.length == 0) {
            this.redraw();
            return;
        }
        for (int i = 0; i < this.visibleObjs.length; ++i) {
            Tile win = (Tile)this.visibleObjs[i];
            if (win == null || win.area == null || win.area != area) continue;
            this.interaction.startDrawSession();
            this.interaction.clearRect(win.x, win.y, win.x + win.width - 1, win.y + win.height - 1);
            this.drawWindow(win);
            this.interaction.endDrawSession();
            return;
        }
    }

    int getAreaVisibleHeight(Area area) {
        if (this.visibleObjs == null || this.visibleObjs.length == 0) {
            return -1;
        }
        for (int i = 0; i < this.visibleObjs.length; ++i) {
            Tile win = (Tile)this.visibleObjs[i];
            if (win == null || win.area == null || win.area != area) continue;
            if (win.height <= 1) {
                return 0;
            }
            return win.height - 1;
        }
        return -1;
    }

    int getAreaVisibleWidth(Area area) {
        if (this.visibleObjs == null || this.visibleObjs.length == 0) {
            return -1;
        }
        for (int i = 0; i < this.visibleObjs.length; ++i) {
            Tile win = (Tile)this.visibleObjs[i];
            if (win == null || win.area == null || win.area != area) continue;
            if (win.height <= 1) {
                return 0;
            }
            return win.width;
        }
        return -1;
    }

    private void calculateGeom(int screenWidth, int screenHeight, Tiles windows) {
        windows.countLeaves();
        this.calculateGeomImpl(windows, windows.getRoot(), 0, 1, screenWidth - 1, screenHeight - 2);
    }

    private void calculateGeomImpl(Tiles windows, Object obj, int left, int top, int right, int bottom) {
        Tile win;
        if (obj == null) {
            return;
        }
        if (Tiles.isLeaf(obj)) {
            if (right - left < 5 || bottom - top < 2) {
                this.markWindowsInvisible(windows, obj);
                return;
            }
            Tile win2 = (Tile)windows.getLeafObject(obj);
            if (win2 == null) {
                return;
            }
            if (win2.popup) {
                this.calculateGeomWithPopup(windows, win2, null, left, top, right, bottom);
                return;
            }
            win2.x = left;
            win2.y = top;
            win2.width = right - left + 1;
            win2.height = bottom - top + 1;
            return;
        }
        Object obj1 = windows.getBranch1(obj);
        Object obj2 = windows.getBranch2(obj);
        if (Tiles.isLeaf(obj1)) {
            win = (Tile)windows.getLeafObject(obj1);
            if (win.popup) {
                this.calculateGeomWithPopup(windows, win, obj2, left, top, right, bottom);
                return;
            }
        }
        if (Tiles.isLeaf(obj2)) {
            win = (Tile)windows.getLeafObject(obj2);
            if (win.popup) {
                this.calculateGeomWithPopup(windows, win, obj1, left, top, right, bottom);
                return;
            }
        }
        int leafCount1 = windows.getLeafCount(obj1);
        int leafCount2 = windows.getLeafCount(obj2);
        if (leafCount1 < 1) {
            this.calculateGeomImpl(windows, obj2, left, top, right, bottom);
            return;
        }
        if (leafCount2 < 1) {
            this.calculateGeomImpl(windows, obj1, left, top, right, bottom);
            return;
        }
        if (windows.getOrientation(obj) == Tiles.Orientation.VERT) {
            int range = bottom - top;
            if (range < 2 || range < leafCount1 + leafCount2) {
                this.markWindowsInvisible(windows, obj);
                return;
            }
            int range1 = range / (leafCount1 + leafCount2) * leafCount1;
            int range2 = range / (leafCount1 + leafCount2) * leafCount2;
            int spaceLeft = range - (range1 + range2);
            this.calculateGeomImpl(windows, obj1, left, top, right, top + (range1 += spaceLeft / 2) - 1);
            this.calculateGeomImpl(windows, obj2, left, top + range1 + 1, right, bottom);
            this.interaction.drawHorizontalLine(left, right, top + range1);
            return;
        }
        if (windows.getOrientation(obj) == Tiles.Orientation.HORIZ) {
            int range = right - left;
            if (range < 5 || range < leafCount1 + leafCount2) {
                this.markWindowsInvisible(windows, obj);
                return;
            }
            int range1 = range / (leafCount1 + leafCount2) * leafCount1;
            int range2 = range / (leafCount1 + leafCount2) * leafCount2;
            int spaceLeft = range - (range1 + range2);
            this.calculateGeomImpl(windows, obj1, left, top, left + (range1 += spaceLeft / 2) - 1, bottom);
            this.calculateGeomImpl(windows, obj2, left + range1 + 1, top, right, bottom);
            this.interaction.drawVerticalLine(top, bottom, left + range1);
            return;
        }
    }

    private void calculateGeomWithPopup(Tiles windows, Tile win, Object anotherNode, int left, int top, int right, int bottom) {
        int anotherBottom;
        int anotherRight;
        int anotherTop;
        int anotherLeft;
        if (win == null || !win.popup || win.area == null) {
            if (anotherNode != null) {
                this.calculateGeomImpl(windows, anotherNode, left, top, right, bottom);
            }
            return;
        }
        Area area = win.area;
        int preferableHeight = area.getLineCount();
        int preferableWidth = 0;
        int linesNumberToCheckLen = preferableHeight < this.interaction.getHeightInCharacters() ? preferableHeight : this.interaction.getHeightInCharacters();
        for (int i = 0; i < linesNumberToCheckLen; ++i) {
            String line = win.area.getLine(i);
            if (line == null || line.length() <= preferableWidth) continue;
            preferableWidth = line.length();
        }
        if (++preferableWidth < 5) {
            preferableWidth = 5;
        }
        if (++preferableHeight < 2) {
            preferableHeight = 2;
        }
        int maxHeight = bottom - top + 1 - 2 - 1;
        int maxWidth = right - left + 1 - 5 - 1;
        if (maxHeight > 7 && (win.popupPos == Popup.Position.TOP || win.popupPos == Popup.Position.BOTTOM)) {
            maxHeight = 7;
        }
        if (maxWidth < 5 || maxHeight < 2) {
            win.markInvisible();
            this.markWindowsInvisible(windows, anotherNode);
            return;
        }
        int popupWidth = preferableWidth <= maxWidth ? preferableWidth : maxWidth;
        int popupHeight = preferableHeight <= maxHeight ? preferableHeight : maxHeight;
        switch (win.popupPos) {
            case LEFT: {
                win.x = left;
                win.y = top;
                win.width = popupWidth;
                win.height = bottom - top + 1;
                anotherLeft = left + popupWidth + 1;
                anotherTop = top;
                anotherRight = right;
                anotherBottom = bottom;
                this.interaction.drawVerticalLine(top, bottom, left + popupWidth);
                break;
            }
            case TOP: {
                win.x = left;
                win.y = top;
                win.width = right - left + 1;
                win.height = popupHeight;
                anotherLeft = left;
                anotherTop = top + popupHeight + 1;
                anotherRight = right;
                anotherBottom = bottom;
                this.interaction.drawHorizontalLine(left, right, top + popupHeight);
                break;
            }
            case RIGHT: {
                win.x = right - popupWidth + 1;
                win.y = top;
                win.width = popupWidth;
                win.height = bottom - top + 1;
                anotherLeft = left;
                anotherTop = top;
                anotherRight = right - popupWidth - 1;
                anotherBottom = bottom;
                this.interaction.drawVerticalLine(top, bottom, right - popupWidth);
                break;
            }
            case BOTTOM: {
                win.x = left;
                win.y = bottom - popupHeight + 1;
                win.width = right - left + 1;
                win.height = popupHeight;
                anotherLeft = left;
                anotherTop = top;
                anotherRight = right;
                anotherBottom = bottom - popupHeight - 1;
                this.interaction.drawHorizontalLine(left, right, bottom - popupHeight);
                break;
            }
            default: {
                win.markInvisible();
                if (anotherNode != null) {
                    this.calculateGeomImpl(windows, anotherNode, left, top, right, bottom);
                }
                return;
            }
        }
        if (anotherNode != null) {
            this.calculateGeomImpl(windows, anotherNode, anotherLeft, anotherTop, anotherRight, anotherBottom);
        }
    }

    private void calculateScrolling(Tile win) {
        if (win == null || win.area == null) {
            return;
        }
        int hotPointX = win.area.getHotPointX();
        int hotPointY = win.area.getHotPointY();
        win.scrolledVert = hotPointY / (win.height - 1) * (win.height - 1);
        win.scrolledHoriz = hotPointX / win.width * win.width;
    }

    private void markWindowsInvisible(Tiles windows, Object obj) {
        if (obj == null) {
            return;
        }
        if (Tiles.isLeaf(obj)) {
            Tile win = (Tile)windows.getLeafObject(obj);
            win.markInvisible();
            return;
        }
        this.markWindowsInvisible(windows, windows.getBranch1(obj));
        this.markWindowsInvisible(windows, windows.getBranch2(obj));
    }

    private void drawWindow(Tile win) {
        int count;
        if (win == null || win.area == null) {
            return;
        }
        if (win.width < 5 || win.height < 2) {
            return;
        }
        this.calculateScrolling(win);
        Area area = win.area;
        if (win.scrolledVert < 0 || win.scrolledVert >= area.getLineCount()) {
            return;
        }
        String name = area.getAreaName();
        if (name != null && !name.isEmpty()) {
            this.interaction.drawText(win.x, win.y, name.length() <= win.width ? name : name.substring(0, win.width), true);
        }
        if ((count = area.getLineCount() - win.scrolledVert) > win.height - 1) {
            count = win.height - 1;
        }
        for (int k = 0; k < count; ++k) {
            this.interaction.drawText(win.x, win.y + k + 1, this.getProperLinePart(win, area.getLine(k + win.scrolledVert)));
        }
        if (area == this.screenContentManager.getActiveArea()) {
            int hotPointX = area.getHotPointX() - win.scrolledHoriz;
            int hotPointY = area.getHotPointY() - win.scrolledVert;
            if (hotPointX >= 0 && hotPointX < win.width && hotPointY >= 0 && hotPointY < win.height - 1) {
                this.interaction.setHotPoint(hotPointX + win.x, hotPointY + win.y + 1);
            }
        }
    }

    private String getProperLinePart(Tile win, String line) {
        if (win == null || line == null || line.isEmpty()) {
            return "";
        }
        if (win.scrolledHoriz >= line.length()) {
            return "";
        }
        String l = win.scrolledHoriz == 0 ? line : line.substring(win.scrolledHoriz);
        return l.length() <= win.width ? l : l.substring(0, win.width);
    }
}

