/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import org.luwrain.core.Log;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Worker;

class WorkersTracking {
    private static final String LOG_COMPONENT = "core";
    private final Map<String, Entry> workers = new HashMap<String, Entry>();
    private volatile boolean continueWork = true;

    WorkersTracking() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean runExplicitly(String workerName) {
        Entry e;
        NullCheck.notEmpty((Object)workerName, (String)"workerName");
        if (!this.workers.containsKey(workerName)) {
            return false;
        }
        Entry entry = e = this.workers.get(workerName);
        synchronized (entry) {
            if (e.task != null && !e.task.isDone()) {
                return false;
            }
            e.task = new FutureTask<Object>(e.worker, null);
            e.executor.execute(e.task);
        }
        return true;
    }

    void doWork(Worker[] workersList) {
        NullCheck.notNullItems((Object[])workersList, (String)"workersList");
        this.workers.clear();
        for (Worker w : workersList) {
            String name = w.getExtObjName();
            if (this.workers.containsKey(name)) {
                Log.warning(LOG_COMPONENT, "trying to register workers with the same name '" + name + "' twice, only the first one is accepted");
                continue;
            }
            this.workers.put(name, new Entry(name, w));
        }
        new Thread(() -> {
            int counter = 0;
            while (this.continueWork) {
                for (Map.Entry<String, Entry> entry : this.workers.entrySet()) {
                    Entry e;
                    Entry entry2 = e = entry.getValue();
                    synchronized (entry2) {
                        if (e.task != null && !e.task.isDone()) {
                            continue;
                        }
                        int delay = e.worker.getFirstLaunchDelay();
                        int period = e.worker.getLaunchPeriod();
                        if (delay < 0 || period <= 0) {
                            continue;
                        }
                        if (counter >= delay && (counter - delay) % period == 0) {
                            e.task = new FutureTask<Object>(e.worker, null);
                            e.executor.execute(e.task);
                        }
                    }
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    return;
                }
                ++counter;
            }
        }, "luwrain.workers").start();
    }

    void finish() {
        this.continueWork = false;
    }

    private static class Entry {
        final ExecutorService executor = Executors.newSingleThreadExecutor();
        final String name;
        final Worker worker;
        FutureTask task = null;

        Entry(String name, Worker worker) {
            NullCheck.notEmpty((Object)name, (String)"name");
            NullCheck.notNull((Object)worker, (String)"worker");
            this.name = name;
            this.worker = worker;
        }
    }
}

