/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core.listening;

import org.luwrain.core.Area;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.ListenableArea;
import org.luwrain.core.NullCheck;
import org.luwrain.core.events.ListeningFinishedEvent;
import org.luwrain.core.queries.BeginListeningQuery;

final class CompatArea
implements ListenableArea {
    private final Area area;

    CompatArea(Area area) {
        NullCheck.notNull((Object)area, (String)"area");
        this.area = area;
    }

    @Override
    public ListenableArea.ListeningInfo onListeningStart() {
        BeginListeningQuery query = new BeginListeningQuery();
        if (!AreaQuery.ask(this.area, query)) {
            return null;
        }
        return new Info(query.getAnswer().getText(), query.getAnswer().getExtraInfo(), -1, -1);
    }

    @Override
    public void onListeningFinish(ListenableArea.ListeningInfo listeningInfo) {
        NullCheck.notNull((Object)listeningInfo, (String)"listeningInfo");
        if (!(listeningInfo instanceof Info)) {
            return;
        }
        Info info = (Info)listeningInfo;
        this.area.onSystemEvent(new ListeningFinishedEvent(info.extraData));
    }

    private static final class Info
    extends ListenableArea.ListeningInfo {
        final Object extraData;

        Info(String text, Object extraData, int posX, int posY) {
            super(text, posX, posY);
            this.extraData = extraData;
        }
    }
}

