/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.core.sound;

import java.io.File;
import java.net.MalformedURLException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import org.luwrain.core.BkgSounds;
import org.luwrain.core.Configs;
import org.luwrain.core.ExtObjects;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.core.sound.BkgPlayer;
import org.luwrain.core.sound.Config;
import org.luwrain.core.sound.Icons;

public final class Manager {
    private final Configs configs;
    private final ExtObjects extObjs;
    private final Icons icons;
    private final Path soundsDir;
    private BkgPlayer bkgPlayer = null;
    private boolean startingMode = false;

    public Manager(ExtObjects extObjs, Luwrain luwrain, Configs configs, Path soundsDir) {
        Objects.requireNonNull(luwrain, "luwrain can't be null");
        this.extObjs = Objects.requireNonNull(extObjs, "");
        this.configs = Objects.requireNonNull(configs, "configs can't be null");
        this.soundsDir = Objects.requireNonNull(soundsDir, "soundsDir can't be null");
        this.icons = new Icons(configs);
    }

    public void playIcon(Sounds sound) {
        if (sound == null) {
            this.icons.stop();
            return;
        }
        String volumeStr = "100";
        int volume = 100;
        try {
            if (!"100".trim().isEmpty()) {
                volume = Integer.parseInt("100");
            }
        }
        catch (NumberFormatException e) {
            volume = 100;
        }
        volume = Math.max(volume, 0);
        volume = Math.min(volume, 1100);
        this.icons.play(sound, volume);
    }

    public void playIcon(File file) {
        Objects.requireNonNull(file, "file can't be null");
        String volumeStr = "50";
        int volume = 100;
        try {
            if (!"50".trim().isEmpty()) {
                volume = Integer.parseInt("50");
            }
        }
        catch (NumberFormatException e) {
            volume = 100;
        }
        if (volume < 0) {
            volume = 0;
        }
        if (volume > 100) {
            volume = 100;
        }
        this.icons.play(file, volume);
    }

    public void cancelIcon() {
        this.icons.stop();
    }

    public void playBackground(BkgSounds sound) {
        Objects.requireNonNull(sound, "sound can't be null");
        this.stopBackground();
        Config conf = this.configs.load(Config.class);
        if (conf == null || conf.bkg == null || !conf.bkg.containsKey((Object)sound)) {
            return;
        }
        this.bkgPlayer = new BkgPlayer(this.extObjs, conf.bkg.get((Object)sound));
        this.bkgPlayer.start();
    }

    public void playBackground(String sound) {
        Objects.requireNonNull(sound, "sound can't be null");
        this.stopBackground();
        if (sound.isEmpty()) {
            return;
        }
        this.bkgPlayer = new BkgPlayer(this.extObjs, sound);
        this.bkgPlayer.start();
    }

    public void stopBackground() {
        if (this.startingMode) {
            return;
        }
        if (this.bkgPlayer != null) {
            this.bkgPlayer.stopPlaying();
        }
        this.bkgPlayer = null;
    }

    public void startingMode() {
        if (this.startingMode) {
            return;
        }
        this.playBackground(BkgSounds.STARTING);
        this.startingMode = true;
    }

    public void stopStartingMode() {
        if (!this.startingMode) {
            return;
        }
        this.startingMode = false;
        this.stopBackground();
    }

    private String getFileUrl(String fileName) {
        NullCheck.notNull((Object)fileName, (String)"fileName");
        if (fileName.isEmpty()) {
            return "";
        }
        Path path = Paths.get(fileName, new String[0]);
        if (!path.isAbsolute()) {
            path = this.soundsDir.resolve(path);
        }
        try {
            return path.toUri().toURL().toString();
        }
        catch (MalformedURLException e) {
            Log.warning("core", "unable to construct sound file URL using string '" + fileName + "'");
            return fileName;
        }
    }
}

