/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.i18n;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.i18n.Lang;
import org.luwrain.nlp.GrammaticalAttr;
import org.luwrain.nlp.Word;

public abstract class LangBase
implements Lang {
    protected final String langName;
    protected final Luwrain luwrain;
    protected final Map<String, String> staticStrings;
    protected final Map<String, String> chars;

    public LangBase(String langName, Luwrain luwrain, Map<String, String> staticStrings, Map<String, String> chars) {
        Objects.requireNonNull(langName, "langName can't be null");
        Objects.requireNonNull(luwrain, "luwrain can't be null");
        Objects.requireNonNull(staticStrings, "staticStrings can't be null");
        Objects.requireNonNull(chars, "chars can't be null");
        if (langName.isEmpty()) {
            throw new IllegalArgumentException("langName can't be empty");
        }
        this.langName = langName;
        this.luwrain = luwrain;
        this.staticStrings = staticStrings;
        this.chars = chars;
    }

    @Override
    public String getStaticStr(String id) {
        NullCheck.notEmpty((Object)id, (String)"id");
        return this.staticStrings.get(id);
    }

    @Override
    public String hasSpecialNameOfChar(char ch) {
        if (Character.isLetterOrDigit(ch)) {
            return null;
        }
        String name = Character.getName(ch);
        if (name == null || name.isEmpty()) {
            return null;
        }
        String newName = name.toLowerCase().replaceAll(" ", "_").replaceAll("-", "_");
        return this.chars.containsKey(newName) ? this.chars.get(newName) : newName;
    }

    @Override
    public String getNumberStr(Number num, GrammaticalAttr gramAttr, Word depWord) {
        return null;
    }

    @Override
    public Word[] getWord(String word) {
        return new Word[0];
    }

    @Override
    public InputStream getResource(String resourceName) {
        NullCheck.notEmpty((Object)resourceName, (String)"resourceName");
        URL url = this.getClass().getClassLoader().getResource("org/luwrain/i18n/" + this.langName + "/" + resourceName);
        if (url == null) {
            return null;
        }
        try {
            return url.openStream();
        }
        catch (IOException e) {
            Log.error(this.langName, "unable to open stream for the lang resource '" + resourceName + "':" + e.getClass().getName() + ":" + e.getMessage());
            return null;
        }
    }

    @Override
    public String getTextExp(String expName, Function<Object, Object> args) {
        NullCheck.notEmpty((Object)expName, (String)"expName");
        NullCheck.notNull(args, (String)"args");
        try {
            return null;
        }
        catch (RuntimeException e) {
            Log.error(this.langName, "unable to run the luwrain.i18n." + this.langName + ".text hook for " + expName + ":" + e.getClass().getName() + ":" + e.getMessage());
            return null;
        }
    }
}

