/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.i18n;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Proxy;
import java.net.URL;
import java.util.Properties;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;

public final class PropertiesProxy {
    private static final String LOG_COMPONENT = "i18n";
    private static final String CHARSET = "UTF-8";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T create(Luwrain luwrain, String langName, URL url, String prefix, Class cl) throws IOException {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notEmpty((Object)langName, (String)"langName");
        NullCheck.notNull((Object)url, (String)"url");
        NullCheck.notNull((Object)prefix, (String)"prefix");
        NullCheck.notNull((Object)cl, (String)"cl");
        Properties props = new Properties();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), CHARSET));){
            props.load(reader);
        }
        return PropertiesProxy.create(luwrain, langName, props, prefix, cl);
    }

    public static <T> T create(Luwrain luwrain, String langName, Properties props, String prefix, Class cl) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notEmpty((Object)langName, (String)"langName");
        NullCheck.notNull((Object)props, (String)"props");
        NullCheck.notNull((Object)prefix, (String)"prefix");
        NullCheck.notNull((Object)cl, (String)"cl");
        return (T)Proxy.newProxyInstance(cl.getClassLoader(), new Class[]{cl}, (object, method, args) -> {
            String value;
            Object name = method.getName();
            if (((String)name).length() > 1 && Character.isLowerCase(((String)name).charAt(0))) {
                name = Character.toUpperCase(((String)name).charAt(0)) + ((String)name).substring(1);
            }
            if ((value = props.getProperty(prefix + (String)name)) == null) {
                String hookRes;
                Object[] a;
                if (args != null) {
                    a = new Object[args.length];
                    for (int i = 0; i < args.length; ++i) {
                        a[i] = args[i] == null ? null : (args[i] instanceof String || args[i] instanceof Number || args[i] instanceof Boolean ? args[i] : args[i].toString());
                    }
                } else {
                    a = new Object[]{};
                }
                if ((hookRes = PropertiesProxy.runHook(luwrain, langName, cl.getName(), a)) != null) {
                    return hookRes;
                }
                return "#No value: " + prefix + (String)name + "#";
            }
            if (value.indexOf("$") < 0) {
                return value.trim();
            }
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < value.length(); ++i) {
                if (value.charAt(i) != '$' || i + 1 >= value.length() || value.charAt(i + 1) < '0' || value.charAt(i + 1) > '9') {
                    b.append(value.charAt(i));
                    continue;
                }
                b.append(args[value.charAt(++i) - 49].toString());
            }
            return new String(b).toString();
        });
    }

    public static String runHook(Luwrain luwrain, String langName, String name, Object[] args) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notEmpty((Object)langName, (String)"langName");
        NullCheck.notNull((Object)name, (String)"name");
        NullCheck.notNullItems((Object[])args, (String)"args");
        return null;
    }
}

