/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.linux;

import java.util.EnumSet;
import java.util.Set;
import org.luwrain.core.NullCheck;

public final class MountParams {
    private final String devName;
    private final String point;
    private final Set<Flags> flags;

    public MountParams(String devName, String point, Set<Flags> flags) {
        NullCheck.notEmpty((Object)devName, (String)"devName");
        NullCheck.notEmpty((Object)point, (String)"point");
        NullCheck.notNull(flags, (String)"flags");
        this.devName = devName;
        this.point = point;
        this.flags = flags;
    }

    public MountParams(String devName, String point) {
        this(devName, point, EnumSet.noneOf(Flags.class));
    }

    public String getDevName() {
        return this.devName;
    }

    public String getPoint() {
        return this.point;
    }

    public Set<Flags> getFlags() {
        return this.flags;
    }

    public static enum Flags {
        RW,
        RO;

    }
}

