/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.player;

import java.net.MalformedURLException;
import java.net.URL;
import org.luwrain.core.NullCheck;
import org.luwrain.player.Playlist;
import org.luwrain.player.ProgressListener;
import org.luwrain.player.VolumeListener;

public final class FixedPlaylist
implements Playlist {
    private final String[] urls;
    private final VolumeListener volumeListener;
    private final ProgressListener progressListener;
    private int volume = 100;

    public FixedPlaylist(String[] urls, ProgressListener progressListener, VolumeListener volumeListener, int volume) {
        NullCheck.notNullItems((Object[])urls, (String)"urls");
        this.volumeListener = volumeListener;
        this.progressListener = progressListener;
        this.volume = Math.min(Math.max(volume, 0), 100);
        this.urls = new String[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            URL u;
            try {
                u = new URL(urls[i]);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
            this.urls[i] = u.toString();
        }
    }

    public FixedPlaylist(String[] urls, VolumeListener volumeListener, int volume) {
        this(urls, null, volumeListener, 100);
    }

    public FixedPlaylist(String[] urls) {
        this(urls, null, 100);
    }

    public FixedPlaylist(String url) {
        this(new String[]{url});
    }

    public String[] getAllTracks() {
        return (String[])this.urls.clone();
    }

    @Override
    public int getTrackCount() {
        return this.urls.length;
    }

    @Override
    public String getTrackUrl(int index) {
        return this.urls[index];
    }

    @Override
    public int getVolume() {
        return this.volume;
    }

    @Override
    public void onNewVolume(int newVolumeLevel) {
        this.volume = newVolumeLevel;
        if (this.volumeListener != null) {
            this.volumeListener.onNewVolume(this.volume);
        }
    }

    @Override
    public void onProgress(int trackIndex, long timeMsec) {
        if (this.progressListener != null) {
            this.progressListener.onProgress(trackIndex, timeMsec);
        }
    }
}

