/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.popups;

import java.util.Set;
import org.luwrain.core.Action;
import org.luwrain.core.AreaQuery;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Popup;
import org.luwrain.core.Sounds;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.core.queries.RegionTextQuery;
import org.luwrain.popups.PopupClosingTranslator;

public class YesNoPopup
implements Popup,
PopupClosingTranslator.Provider {
    protected final Luwrain luwrain;
    protected final PopupClosingTranslator closing = new PopupClosingTranslator(this);
    protected final String name;
    protected final String text;
    protected boolean res;
    protected final boolean defaultRes;
    protected final Set<Popup.Flags> popupFlags;

    public YesNoPopup(Luwrain luwrain, String name, String text, boolean defaultRes, Set<Popup.Flags> popupFlags) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        NullCheck.notNull((Object)name, (String)"name");
        NullCheck.notNull((Object)text, (String)"text");
        NullCheck.notNull(popupFlags, (String)"popupFlags");
        this.luwrain = luwrain;
        this.name = name;
        this.text = text;
        this.defaultRes = defaultRes;
        this.res = defaultRes;
        this.popupFlags = popupFlags;
    }

    protected String getSpeakableText(String text) {
        NullCheck.notNull((Object)text, (String)"text");
        return this.luwrain.getSpeakableText(text, Luwrain.SpeakableTextType.NATURAL);
    }

    @Override
    public int getLineCount() {
        return 1;
    }

    @Override
    public String getLine(int index) {
        return index == 0 ? this.text : "";
    }

    @Override
    public int getHotPointX() {
        return this.text.length();
    }

    @Override
    public int getHotPointY() {
        return 0;
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (this.closing.onInputEvent(event)) {
            return true;
        }
        if (!event.isSpecial()) {
            char c = event.getChar();
            if (InputEvent.getKeyboardLayout().onSameButton(c, 'y')) {
                this.res = true;
                this.closing.doOk();
                return true;
            }
            if (InputEvent.getKeyboardLayout().onSameButton(c, 'n')) {
                this.res = false;
                this.closing.doOk();
                return true;
            }
            return false;
        }
        if (event.isModified()) {
            return false;
        }
        switch (event.getSpecial()) {
            case ENTER: {
                this.closing.doOk();
                return true;
            }
            case ARROW_UP: 
            case ARROW_DOWN: 
            case ARROW_LEFT: 
            case ARROW_RIGHT: {
                this.luwrain.speak(this.getSpeakableText(this.text));
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        NullCheck.notNull((Object)event, (String)"event");
        if (event.getType() != SystemEvent.Type.REGULAR) {
            return false;
        }
        switch (event.getCode()) {
            case CLIPBOARD_COPY: 
            case CLIPBOARD_COPY_ALL: {
                this.luwrain.getClipboard().set(this.text);
                return true;
            }
            case INTRODUCE: {
                this.luwrain.speak(this.getSpeakableText(this.text), Sounds.POPUP);
                return true;
            }
        }
        return this.closing.onSystemEvent(event);
    }

    @Override
    public boolean onAreaQuery(AreaQuery query) {
        NullCheck.notNull((Object)query, (String)"query");
        switch (query.getQueryCode()) {
            case 8: {
                if (!(query instanceof RegionTextQuery)) {
                    return false;
                }
                RegionTextQuery regionTextQuery = (RegionTextQuery)query;
                regionTextQuery.answer(this.text);
                return true;
            }
        }
        return false;
    }

    @Override
    public Action[] getAreaActions() {
        return new Action[0];
    }

    @Override
    public String getAreaName() {
        return this.name;
    }

    public boolean result() {
        return this.res;
    }

    @Override
    public boolean onOk() {
        return true;
    }

    @Override
    public boolean onCancel() {
        return true;
    }

    @Override
    public Luwrain getLuwrainObject() {
        return this.luwrain;
    }

    @Override
    public boolean isPopupActive() {
        return this.closing.continueEventLoop();
    }

    public boolean wasCancelled() {
        return this.closing.cancelled();
    }

    @Override
    public Set<Popup.Flags> getPopupFlags() {
        return this.popupFlags;
    }
}

