/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script.core;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.luwrain.core.HotPoint;
import org.luwrain.core.NullCheck;

public class HotPointObj
implements ProxyObject {
    private static final String[] KEYS = new String[]{"x", "y"};
    private static final Set<String> KEYS_SET = new HashSet<String>(Arrays.asList(KEYS));
    private static final ProxyArray KEYS_ARRAY = ProxyArray.fromArray((Object[])KEYS);
    private final HotPoint hotPoint;

    public HotPointObj(HotPoint hotPoint) {
        this.hotPoint = Objects.requireNonNull(hotPoint, "hotPoint can't be null");
    }

    public Object getMember(String name) {
        NullCheck.notEmpty((Object)name, (String)"name");
        switch (name) {
            case "x": {
                return this.hotPoint.getHotPointX();
            }
            case "y": {
                return this.hotPoint.getHotPointY();
            }
        }
        return null;
    }

    public boolean hasMember(String name) {
        return KEYS_SET.contains(name);
    }

    public Object getMemberKeys() {
        return KEYS_ARRAY;
    }

    public void putMember(String name, Value value) {
        throw new UnsupportedOperationException("The hot point object doesn't support updating of its variables");
    }
}

