/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script.core;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.graalvm.polyglot.proxy.ProxyObject;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.script.core.LangObj;
import org.luwrain.script.core.LangsObj;

final class I18nObj
implements ProxyObject {
    private static String[] KEYS = new String[]{"lang", "langs"};
    private static final Set<String> KEYS_SET = new HashSet<String>(Arrays.asList(KEYS));
    private static final ProxyArray KEYS_ARRAY = ProxyArray.fromArray((Object[])KEYS);
    private final Luwrain luwrain;
    private LangObj activeLangObj = null;
    private LangsObj langsObj = null;

    I18nObj(Luwrain luwrain) {
        NullCheck.notNull((Object)luwrain, (String)"luwrain");
        this.luwrain = luwrain;
        this.refresh();
    }

    void refresh() {
        this.activeLangObj = this.luwrain.i18n().getActiveLang() != null ? new LangObj(this.luwrain.i18n().getActiveLang()) : null;
        this.langsObj = new LangsObj(this.luwrain.i18n());
    }

    public Object getMember(String name) {
        NullCheck.notNull((Object)name, (String)"name");
        switch (name) {
            case "lang": {
                return this.activeLangObj;
            }
            case "langs": {
                return this.langsObj;
            }
        }
        return null;
    }

    public boolean hasMember(String name) {
        return KEYS_SET.contains(name);
    }

    public Object getMemberKeys() {
        return KEYS_ARRAY;
    }

    public void putMember(String name, Value value) {
        throw new RuntimeException("The i18n object doesn't support updating of its variables");
    }
}

