/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script.core;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.FutureTask;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.graalvm.polyglot.proxy.ProxyExecutable;
import org.jsoup.nodes.Document;
import org.jsoup.parser.Parser;
import org.luwrain.controls.ControlContext;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.core.Command;
import org.luwrain.core.ExtensionObject;
import org.luwrain.core.Job;
import org.luwrain.core.Log;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Sounds;
import org.luwrain.script.AsyncFunction;
import org.luwrain.script.ScriptUtils;
import org.luwrain.script.controls.WizardAreaObj;
import org.luwrain.script.core.AppImpl;
import org.luwrain.script.core.CommandImpl;
import org.luwrain.script.core.ConstObj;
import org.luwrain.script.core.I18nObj;
import org.luwrain.script.core.JobInstanceObj;
import org.luwrain.script.core.LogObj;
import org.luwrain.script.core.LuwrainObjBase;
import org.luwrain.script.core.Module;
import org.luwrain.script.core.PopupsObj;
import org.luwrain.script.core.ScriptException;
import org.luwrain.script.core.ShortcutImpl;
import org.luwrain.script.core.WorkerImpl;
import org.luwrain.script.ml.JSoupDocObj;
import org.luwrain.util.FileUtils;

public final class LuwrainObj
extends LuwrainObjBase {
    @HostAccess.Export
    public final LogObj log;
    @HostAccess.Export
    public final ConstObj constants = new ConstObj();
    @HostAccess.Export
    public final PopupsObj popups;
    final Object syncObj;
    final Map<String, List<Value>> hooks = new HashMap<String, List<Value>>();
    final List<ExtensionObject> extObjs = new ArrayList<ExtensionObject>();
    final I18nObj i18nObj;
    final List<Command> commands = new ArrayList<Command>();
    @HostAccess.Export
    public final ProxyExecutable escapeString = this::escapeStringImpl;
    @HostAccess.Export
    public final ProxyExecutable deleteFile = this::deleteFileImpl;
    @HostAccess.Export
    public final ProxyExecutable addCommand = this::addCommandImpl;
    @HostAccess.Export
    public final ProxyExecutable addHook = this::addHookImpl;
    @HostAccess.Export
    public final ProxyExecutable addShortcut = this::addShortcutImpl;
    @HostAccess.Export
    public final ProxyExecutable addWorker = this::addWorkerImpl;
    @HostAccess.Export
    public final ProxyExecutable executeBkg = this::executeBkgImpl;
    @HostAccess.Export
    public final ProxyExecutable i18n = this::i18nImpl;
    @HostAccess.Export
    public final ProxyExecutable isDigit = this::isDigitImpl;
    @HostAccess.Export
    public final ProxyExecutable isLetter = this::isLetterImpl;
    @HostAccess.Export
    public final ProxyExecutable isLetterOrDigit = this::isLetterOrDigitImpl;
    @HostAccess.Export
    public final ProxyExecutable isSpace = this::isSpaceImpl;
    @HostAccess.Export
    public final ProxyExecutable launchApp = this::launchAppImpl;
    @HostAccess.Export
    public final ProxyExecutable message = this::messageImpl;
    @HostAccess.Export
    public final ProxyExecutable newJob = this::newJobImpl;
    @HostAccess.Export
    public final ProxyExecutable openUrl = this::openUrlImpl;
    @HostAccess.Export
    public final ProxyExecutable playSound = this::playSoundImpl;
    @HostAccess.Export
    public final ProxyExecutable readTextFile = this::readTextFileImpl;
    @HostAccess.Export
    public final ProxyExecutable writeTextFile = this::writeTextFileImpl;
    @HostAccess.Export
    public final ProxyExecutable quit = this::quitImpl;
    @HostAccess.Export
    public final ProxyExecutable urlGet = this::urlGetImpl;
    @HostAccess.Export
    public final ProxyExecutable createWizardArea = this::createWizardAreaImpl;
    @HostAccess.Export
    public ProxyExecutable parseXml = this::parseXmlImpl;
    @HostAccess.Export
    public final ProxyExecutable fetchUrl;
    @HostAccess.Export
    public final ProxyExecutable speak;

    LuwrainObj(Luwrain luwrain, Object syncObj, Module module) {
        super(module, luwrain);
        this.fetchUrl = AsyncFunction.create(this.module.context, this.module.syncObj, (args, res) -> {
            if (!ScriptUtils.notNullAndLen(args, 1)) {
                throw new IllegalArgumentException("Luwrain.fetchUrl takes exactly one argument");
            }
            if (!args[0].isString()) {
                throw new IllegalArgumentException("Luwrain.fetchUrl() takes a string as its first argument");
            }
            this.luwrain.executeBkg(() -> {
                try (BufferedReader r = new BufferedReader(new InputStreamReader(new URL(args[0].asString()).openStream()));){
                    StringBuilder b = new StringBuilder();
                    String line = r.readLine();
                    while (line != null) {
                        b.append(line).append(System.lineSeparator());
                        line = r.readLine();
                    }
                    this.luwrain.runUiSafely(() -> res.complete(new String(b)));
                }
                catch (Throwable e) {
                    Log.error("proba", e.getMessage());
                    throw new ScriptException(e);
                }
            });
        });
        this.speak = this::speakImpl;
        Objects.requireNonNull(luwrain, "luwrain can't be null");
        Objects.requireNonNull(syncObj, "syncObj can't be null");
        Objects.requireNonNull(module, "module can't be null");
        this.syncObj = syncObj;
        this.log = new LogObj(luwrain);
        this.i18nObj = new I18nObj(luwrain);
        this.popups = new PopupsObj(luwrain);
    }

    private Object escapeStringImpl(Value[] args) {
        if (!ScriptUtils.notNullAndLen(args, 2)) {
            return false;
        }
        String style = ScriptUtils.asString(args[0]);
        String text = ScriptUtils.asString(args[1]);
        if (style == null || text == null) {
            return false;
        }
        return this.luwrain.escapeString(style, text);
    }

    private Object deleteFileImpl(Value[] args) {
        if (!ScriptUtils.notNullAndLen(args, 1)) {
            return false;
        }
        String fileName = ScriptUtils.asString(args[0]);
        if (fileName == null) {
            return false;
        }
        new File(fileName).delete();
        return true;
    }

    private Object addCommandImpl(Value[] args) {
        if (!ScriptUtils.notNullAndLen(args, 2)) {
            return false;
        }
        if (!args[0].isString() || !args[1].canExecute()) {
            return false;
        }
        String name = args[0].asString();
        if (name.trim().isEmpty()) {
            return false;
        }
        this.commands.add(new CommandImpl(this.module, name.trim(), args[1]));
        return true;
    }

    private Object addHookImpl(Value[] args) {
        if (!ScriptUtils.notNullAndLen(args, 2)) {
            return false;
        }
        if (!args[0].isString() || !args[1].canExecute()) {
            return false;
        }
        String name = args[0].asString();
        if (name.trim().isEmpty()) {
            return false;
        }
        List<Value> h = this.hooks.get(name);
        if (h == null) {
            h = new ArrayList<Value>();
            this.hooks.put(name, h);
        }
        h.add(args[1]);
        return true;
    }

    private Object addShortcutImpl(Value[] args) {
        if (!ScriptUtils.notNullAndLen(args, 2)) {
            return false;
        }
        if (!args[0].isString() || !args[1].canInstantiate()) {
            return false;
        }
        String name = args[0].asString();
        if (name.trim().isEmpty()) {
            return false;
        }
        this.extObjs.add(new ShortcutImpl(this.module, name.trim(), new File(this.luwrain.getPath("SYS_DATA_DIR")), args[1]));
        return true;
    }

    private Object addWorkerImpl(Value[] args) {
        if (!ScriptUtils.notNullAndLen(args, 4)) {
            return false;
        }
        if (!(args[0].isString() && args[1].isNumber() && args[2].isNumber() && args[3].canExecute())) {
            return false;
        }
        String name = args[0].asString();
        int firstLaunchDelay = args[1].asInt();
        int launchPeriod = args[2].asInt();
        if (name.trim().isEmpty()) {
            return false;
        }
        if (firstLaunchDelay == 0 || launchPeriod == 0) {
            return false;
        }
        this.extObjs.add(new WorkerImpl(this, name.trim(), firstLaunchDelay, launchPeriod, args[3]));
        return true;
    }

    private Object executeBkgImpl(Value[] values) {
        if (!ScriptUtils.notNullAndLen(values, 1)) {
            return false;
        }
        if (values[0].isNull() || !values[0].canExecute()) {
            return false;
        }
        FutureTask<Object> task = new FutureTask<Object>(() -> {
            Object object = this.syncObj;
            synchronized (object) {
                try {
                    values[0].execute(new Object[0]);
                }
                catch (Throwable e) {
                    this.luwrain.crash(e);
                }
            }
            return null;
        });
        this.luwrain.executeBkg(task);
        return true;
    }

    private Object i18nImpl(Value[] args) {
        this.i18nObj.refresh();
        return this.i18nObj;
    }

    private Object isDigitImpl(Value[] values) {
        if (!ScriptUtils.notNullAndLen(values, 1)) {
            return false;
        }
        if (!values[0].isString() || values[0].asString().length() != 1) {
            return false;
        }
        return Character.isDigit(values[0].asString().charAt(0));
    }

    private Object isLetterImpl(Value[] values) {
        if (!ScriptUtils.notNullAndLen(values, 1)) {
            return false;
        }
        if (!values[0].isString() || values[0].asString().length() != 1) {
            return false;
        }
        return Character.isLetter(values[0].asString().charAt(0));
    }

    private Object isLetterOrDigitImpl(Value[] values) {
        if (!ScriptUtils.notNullAndLen(values, 1)) {
            return false;
        }
        if (!values[0].isString() || values[0].asString().length() != 1) {
            return false;
        }
        return Character.isLetterOrDigit(values[0].asString().charAt(0));
    }

    private Object isSpaceImpl(Value[] values) {
        if (!ScriptUtils.notNullAndLen(values, 1)) {
            return false;
        }
        if (!values[0].isString() || values[0].asString().length() != 1) {
            return false;
        }
        return Character.isWhitespace(values[0].asString().charAt(0));
    }

    private Object launchAppImpl(Value[] values) {
        if (ScriptUtils.notNullAndLen(values, 2)) {
            if (!values[1].hasArrayElements()) {
                return false;
            }
            String[] args = ScriptUtils.asStringArray(values[1]);
            if (args == null) {
                return false;
            }
            if (values[0].isString()) {
                this.luwrain.launchApp(values[0].asString(), args);
                return true;
            }
            if (!values[0].canInstantiate()) {
                throw new IllegalArgumentException("The first argument to Luwrian.launchApp() must be a string or an executable object");
            }
            if (this.module.internalCoreFuncs == null) {
                throw new IllegalArgumentException("This script core can launch apps by their names only");
            }
            this.module.internalCoreFuncs.launchApp(new AppImpl(this.module, values[0]));
            return true;
        }
        if (!ScriptUtils.notNullAndLen(values, 1)) {
            return false;
        }
        if (values[0].isString()) {
            this.luwrain.launchApp(values[0].asString());
            return true;
        }
        if (!values[0].canInstantiate()) {
            throw new IllegalArgumentException("The first argument to Luwrian.launchApp() must be a string or an executable object");
        }
        if (this.module.internalCoreFuncs == null) {
            throw new IllegalArgumentException("This script core can launch apps by their names only");
        }
        this.module.internalCoreFuncs.launchApp(new AppImpl(this.module, values[0]));
        return true;
    }

    private Object messageImpl(Value[] values) {
        Luwrain.MessageType messageType;
        if (!ScriptUtils.notNull(values)) {
            return false;
        }
        if (values.length < 1 || values.length > 2) {
            return true;
        }
        if (!values[0].isString()) {
            return false;
        }
        if (values.length == 2) {
            if (!values[1].isString()) {
                return false;
            }
            messageType = ConstObj.getMessageType(values[1].asString());
        } else {
            messageType = null;
        }
        if (messageType != null) {
            this.luwrain.message(values[0].asString(), messageType);
        } else {
            this.luwrain.message(values[0].asString());
        }
        return true;
    }

    private JobInstanceObj newJobImpl(Value[] values) {
        if (values.length < 2 || values.length > 4) {
            return null;
        }
        if (values[0] == null || values[0].isNull() || !values[0].isString()) {
            return null;
        }
        String name = values[0].asString();
        String[] args = ScriptUtils.asStringArray(values[1]);
        String dir = values.length < 3 || values[2] == null || values[2].isNull() || !values[2].isString() ? "" : values[2].asString();
        final Value finishedFunc = values.length < 4 || values[3] == null || values[3].isNull() || !values[3].canExecute() ? null : values[3];
        Job res = this.luwrain.newJob(name, args != null ? args : new String[]{}, dir, EnumSet.noneOf(Luwrain.JobFlags.class), new Job.Listener(){

            @Override
            public void onInfoChange(Job instance, String type, List<String> value) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStatusChange(Job instance) {
                NullCheck.notNull((Object)instance, (String)"instance");
                if (finishedFunc == null || instance.getStatus() != Job.Status.FINISHED) {
                    return;
                }
                Object object = LuwrainObj.this.syncObj;
                synchronized (object) {
                    finishedFunc.execute(new Object[]{instance.isFinishedSuccessfully(), instance.getExitCode()});
                }
            }
        });
        return res != null ? new JobInstanceObj(res) : null;
    }

    private Object openUrlImpl(Value[] args) {
        if (!ScriptUtils.notNullAndLen(args, 1)) {
            return false;
        }
        if (!args[0].isString()) {
            return false;
        }
        this.luwrain.runUiSafely(() -> this.luwrain.openUrl(args[0].asString()));
        return true;
    }

    private Object playSoundImpl(Value[] values) {
        if (!ScriptUtils.notNullAndLen(values, 1)) {
            return false;
        }
        if (!values[0].isString()) {
            return false;
        }
        Sounds sound = ConstObj.getSound(values[0].asString());
        if (sound == null) {
            return false;
        }
        this.luwrain.playSound(sound);
        return true;
    }

    private Object readTextFileImpl(Value[] args) {
        if (!ScriptUtils.notNullAndLen(args, 1)) {
            return new ScriptException("readTextFile takes exactly one non-null argument");
        }
        String fileName = ScriptUtils.asString(args[0]);
        if (fileName == null || fileName.isEmpty()) {
            throw new ScriptException("readTextFile() takes a non-empty string with the name of the file as the furst argument");
        }
        try {
            String text = FileUtils.readTextFileSingleString(new File(fileName), "UTF-8");
            return ProxyArray.fromArray((Object[])FileUtils.universalLineSplitting(text));
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    private Object writeTextFileImpl(Value[] args) {
        if (!ScriptUtils.notNullAndLen(args, 2)) {
            return new ScriptException("readTextFile takes exactly one non-null argument");
        }
        String fileName = ScriptUtils.asString(args[0]);
        if (fileName == null || fileName.isEmpty()) {
            throw new ScriptException("readTextFile() takes a non-empty string with the name of the file as the furst argument");
        }
        String[] lines = ScriptUtils.asStringArray(args[1]);
        if (lines == null) {
            throw new IllegalArgumentException("No lines to write");
        }
        try {
            FileUtils.writeTextFileMultipleStrings(new File(fileName), lines, "UTF-8", null);
            return true;
        }
        catch (IOException e) {
            throw new ScriptException(e);
        }
    }

    private Object quitImpl(Value[] values) {
        if (values != null && values.length > 0) {
            return false;
        }
        this.luwrain.xQuit();
        return true;
    }

    private Object urlGetImpl(Value[] args) {
        String string;
        if (!ScriptUtils.notNullAndLen(args, 1)) {
            return null;
        }
        if (!args[0].isString()) {
            return null;
        }
        BufferedReader r = new BufferedReader(new InputStreamReader(new URL(args[0].asString()).openStream()));
        try {
            StringBuilder b = new StringBuilder();
            String line = r.readLine();
            while (line != null) {
                b.append(line).append(System.lineSeparator());
                line = r.readLine();
            }
            string = new String(b);
        }
        catch (Throwable throwable) {
            try {
                try {
                    r.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new ScriptException(e);
            }
        }
        r.close();
        return string;
    }

    private Object createWizardAreaImpl(Value[] args) {
        Value onInput;
        if (args != null && args.length != 0 && args[0] != null && !args[0].isNull()) {
            onInput = args[0].getMember("input");
            if (onInput != null && !onInput.isNull() && !onInput.canExecute()) {
                throw new IllegalArgumentException("The input member of the first argument to Luwrain.createWizardArea() must be a function");
            }
        } else {
            onInput = null;
        }
        return new WizardAreaObj((ControlContext)new DefaultControlContext(this.luwrain), this.module, onInput != null && !onInput.isNull() ? onInput : null);
    }

    private Object parseXmlImpl(Value[] args) {
        if (args == null || args.length < 1 || args.length > 2) {
            throw new IllegalArgumentException("Luwrain.parseXml() takes one or two string arguments");
        }
        if (!args[0].isString()) {
            throw new IllegalArgumentException("Luwrain.parseXml() takes a string as the first argument");
        }
        if (args.length == 2 && !args[1].isString()) {
            throw new IllegalArgumentException("Luwrain.parseXml() takes a string as the second argument");
        }
        Parser p = Parser.xmlParser();
        Document doc = args.length == 1 ? p.parseInput(args[0].asString(), "") : p.parseInput(args[0].asString(), args[1].asString());
        return doc != null ? new JSoupDocObj(doc) : null;
    }

    private Object speakImpl(Value[] values) {
        if (ScriptUtils.notNullAndLen(values, 2)) {
            if (!values[0].isString() || !values[1].isString()) {
                return false;
            }
            String text = values[0].asString();
            String sound = values[1].asString();
            if (sound.isEmpty()) {
                return false;
            }
            Sounds s = ConstObj.getSound(sound);
            if (s == null) {
                return false;
            }
            this.luwrain.playSound(s);
            this.luwrain.speak(text);
            return true;
        }
        if (!ScriptUtils.notNullAndLen(values, 1)) {
            return false;
        }
        if (!values[0].isString()) {
            return false;
        }
        this.luwrain.speak(values[0].asString());
        return true;
    }
}

