/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script.core;

import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.luwrain.core.MutableLines;
import org.luwrain.core.NullCheck;

public class MutableLinesArray
implements ProxyArray {
    protected final MutableLines lines;

    public MutableLinesArray(MutableLines lines) {
        NullCheck.notNull((Object)lines, (String)"lines");
        this.lines = lines;
    }

    public Object get(long index) {
        if (index < 0L || index >= (long)this.lines.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException((int)index);
        }
        return this.lines.getLine((int)index);
    }

    public long getSize() {
        return this.lines.getLineCount();
    }

    public void set(long index, Value value) {
        if (value == null || value.isNull()) {
            return;
        }
        String v = value.isString() ? value.asString() : value.toString();
        if (v == null) {
            return;
        }
        if (index < 0L || index >= (long)this.lines.getLineCount()) {
            throw new ArrayIndexOutOfBoundsException((int)index);
        }
        this.lines.setLine((int)index, v);
    }

    public boolean remove(long index) {
        if (index < 0L || index >= (long)this.lines.getLineCount()) {
            return false;
        }
        this.lines.removeLine((int)index);
        return true;
    }
}

