/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script.hooks;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.luwrain.core.HookContainer;
import org.luwrain.core.NullCheck;
import org.luwrain.script.ScriptUtils;

public class CollectorHook {
    protected final HookContainer hookContainer;

    public CollectorHook(HookContainer hookContainer) {
        NullCheck.notNull((Object)hookContainer, (String)"hookContainer");
        this.hookContainer = hookContainer;
    }

    public Object[] run(String hookName, Object[] args) {
        NullCheck.notEmpty((Object)hookName, (String)"hookName");
        NullCheck.notNullItems((Object[])args, (String)"args");
        ArrayList res = new ArrayList();
        AtomicReference ex = new AtomicReference();
        this.hookContainer.runHooks(hookName, hook -> {
            try {
                Object obj = hook.run(args);
                if (obj == null) {
                    return HookContainer.HookResult.CONTINUE;
                }
                res.add(obj);
                return HookContainer.HookResult.CONTINUE;
            }
            catch (RuntimeException e) {
                ex.set(e);
                return HookContainer.HookResult.BREAK;
            }
        });
        if (ex.get() != null) {
            throw (RuntimeException)ex.get();
        }
        return res.toArray(new Object[res.size()]);
    }

    public Object[] runForArrays(String hookName, Object[] args) {
        NullCheck.notNull((Object)hookName, (String)"hookName");
        NullCheck.notNullItems((Object[])args, (String)"args");
        ArrayList<Object> res = new ArrayList<Object>();
        Object[] objs = this.run(hookName, args);
        if (objs == null) {
            return null;
        }
        for (Object o : objs) {
            if (o == null) continue;
            List<Object> values = ScriptUtils.getArrayItems(o);
            if (values == null) {
                res.add(o);
                continue;
            }
            res.addAll(values);
        }
        return res.toArray(new Object[res.size()]);
    }
}

