/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.script.hooks;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.graalvm.polyglot.Value;
import org.luwrain.core.HookContainer;
import org.luwrain.core.NullCheck;

public class PermissionHook {
    protected final HookContainer hookContainer;

    public PermissionHook(HookContainer hookContainer) {
        NullCheck.notNull((Object)hookContainer, (String)"hookContainer");
        this.hookContainer = hookContainer;
    }

    public boolean run(String hookName, Object[] args) {
        NullCheck.notEmpty((Object)hookName, (String)"hookName");
        NullCheck.notNullItems((Object[])args, (String)"args");
        AtomicBoolean execRes = new AtomicBoolean(true);
        AtomicReference error = new AtomicReference();
        this.hookContainer.runHooks(hookName, hook -> {
            try {
                Object res = hook.run(args);
                if (res == null || !(res instanceof Value)) {
                    execRes.set(false);
                    return HookContainer.HookResult.BREAK;
                }
                Value value = (Value)res;
                if (value.isNull() || !value.isBoolean() || !value.asBoolean()) {
                    execRes.set(false);
                    return HookContainer.HookResult.BREAK;
                }
                return HookContainer.HookResult.CONTINUE;
            }
            catch (Throwable e) {
                RuntimeException runtimeEx = !(e instanceof RuntimeException) ? new RuntimeException(e) : (RuntimeException)e;
                error.set(runtimeEx);
                return HookContainer.HookResult.BREAK;
            }
        });
        if (error.get() != null) {
            throw (RuntimeException)error.get();
        }
        return execRes.get();
    }
}

