/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.settings;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.ListArea;
import org.luwrain.controls.ListUtils;
import org.luwrain.controls.list.ListModel;
import org.luwrain.core.Luwrain;
import org.luwrain.core.Suggestions;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.cpanel.ControlPanel;
import org.luwrain.cpanel.SectionArea;
import org.luwrain.io.json.FileType;

final class FileTypes
extends ListArea<Item>
implements SectionArea {
    private final ControlPanel controlPanel;

    FileTypes(ControlPanel controlPanel, ListArea.Params<Item> params) {
        super(params);
        this.controlPanel = controlPanel;
        this.setListClickHandler((area, index, item) -> this.editItem((Item)item));
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        if (this.controlPanel.onInputEvent(event)) {
            return true;
        }
        return super.onInputEvent(event);
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        if (this.controlPanel.onSystemEvent(event)) {
            return true;
        }
        return super.onSystemEvent(event);
    }

    @Override
    public boolean saveSectionData() {
        return true;
    }

    private boolean editItem(Item item) {
        return false;
    }

    private static List<Item> loadItems(Luwrain luwrain) {
        ArrayList<Item> res = new ArrayList<Item>();
        org.luwrain.io.json.FileTypes conf = luwrain.loadConf(org.luwrain.io.json.FileTypes.class);
        if (conf == null || conf.getTypes() == null) {
            return res;
        }
        Map<String, ArrayList> m = conf.getTypes().entrySet().stream().filter(e -> e.getValue() != null && !Objects.requireNonNullElse(((FileType)e.getValue()).getName(), "").isEmpty()).collect(Collectors.toMap(e -> ((FileType)e.getValue()).getName(), e -> new ArrayList<String>(List.of((String)e.getKey())), (e1, e2) -> {
            e1.addAll(e2);
            return e1;
        }));
        return m.entrySet().stream().map(e -> new Item((String)e.getKey(), (List)e.getValue())).toList();
    }

    static FileTypes create(ControlPanel controlPanel) {
        Luwrain luwrain = controlPanel.getCoreInterface();
        ListArea.Params<Item> params = new ListArea.Params<Item>();
        params.context = new DefaultControlContext(luwrain);
        params.appearance = new ListUtils.DefaultAppearance(params.context, Suggestions.LIST_ITEM);
        params.name = luwrain.getString("static:CpFileTypes");
        List<Item> items = FileTypes.loadItems(luwrain);
        params.model = new ListModel<Item>(items);
        return new FileTypes(controlPanel, params);
    }

    static final class Item
    implements Comparable {
        final String name;
        final List<String> ext;

        public String toString() {
            return this.name;
        }

        public int compareTo(Object o) {
            if (o != null && o instanceof Item) {
                Item item = (Item)o;
                return this.name.compareTo(item.name);
            }
            return 0;
        }

        public Item(String name, List<String> ext) {
            this.name = name;
            this.ext = ext;
        }
    }
}

