/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.settings;

import org.luwrain.controls.DefaultControlContext;
import org.luwrain.controls.FormArea;
import org.luwrain.core.Luwrain;
import org.luwrain.core.NullCheck;
import org.luwrain.core.Settings;
import org.luwrain.core.events.InputEvent;
import org.luwrain.core.events.SystemEvent;
import org.luwrain.cpanel.ControlPanel;
import org.luwrain.cpanel.SectionArea;

final class Speech
extends FormArea
implements SectionArea {
    private final ControlPanel controlPanel;
    private final Luwrain luwrain;
    private final Settings.SpeechParams sett;

    Speech(ControlPanel controlPanel, String name) {
        super(new DefaultControlContext(controlPanel.getCoreInterface()), name);
        this.controlPanel = controlPanel;
        this.luwrain = controlPanel.getCoreInterface();
        this.sett = null;
        this.addEdit("main-engine-name", this.luwrain.i18n().getStaticStr("CpSpeechMainEngineName"), this.sett.getMainEngineName(""));
        this.addEdit("main-engine-params", this.luwrain.i18n().getStaticStr("CpSpeechMainEngineParams"), this.sett.getMainEngineParams(""));
        this.addEdit("listening-engine-name", this.luwrain.i18n().getStaticStr("CpSpeechListeningEngineName"), this.sett.getListeningEngineName(""));
        this.addEdit("listening-engine-params", this.luwrain.i18n().getStaticStr("CpSpeechListeningEngineParams"), this.sett.getListeningEngineParams(""));
        this.addEdit("listening-pitch", this.luwrain.i18n().getStaticStr("CpSpeechListeningPitch"), "" + this.sett.getListeningPitch(50));
        this.addEdit("listening-rate", this.luwrain.i18n().getStaticStr("CpSpeechListeningRate"), "" + this.sett.getListeningRate(50));
    }

    @Override
    public boolean saveSectionData() {
        int listeningRate;
        int listeningPitch;
        this.sett.setMainEngineName(this.getEnteredText("main-engine-name"));
        this.sett.setMainEngineParams(this.getEnteredText("main-engine-params"));
        this.sett.setListeningEngineName(this.getEnteredText("listening-engine-name"));
        this.sett.setListeningEngineParams(this.getEnteredText("listening-engine-params"));
        try {
            listeningPitch = Integer.parseInt(this.getEnteredText("listening-pitch"));
        }
        catch (NumberFormatException e) {
            this.luwrain.message(this.luwrain.i18n().getStaticStr("CpSpeechInvalidListeningPitch"), Luwrain.MessageType.ERROR);
            return false;
        }
        if (listeningPitch < 0 || listeningPitch > 100) {
            this.luwrain.message(this.luwrain.i18n().getStaticStr("CpSpeechInvalidListeningPitch"), Luwrain.MessageType.ERROR);
            return false;
        }
        this.sett.setListeningPitch(listeningPitch);
        try {
            listeningRate = Integer.parseInt(this.getEnteredText("listening-rate"));
        }
        catch (NumberFormatException e) {
            this.luwrain.message(this.luwrain.i18n().getStaticStr("CpSpeechInvalidListeningRate"), Luwrain.MessageType.ERROR);
            return false;
        }
        if (listeningRate < 0 || listeningRate > 100) {
            this.luwrain.message(this.luwrain.i18n().getStaticStr("CpSpeechInvalidListeningRate"), Luwrain.MessageType.ERROR);
            return false;
        }
        this.sett.setListeningRate(listeningRate);
        return true;
    }

    @Override
    public boolean onInputEvent(InputEvent event) {
        if (this.controlPanel.onInputEvent(event)) {
            return true;
        }
        return super.onInputEvent(event);
    }

    @Override
    public boolean onSystemEvent(SystemEvent event) {
        if (this.controlPanel.onSystemEvent(event)) {
            return true;
        }
        return super.onSystemEvent(event);
    }

    static Speech create(ControlPanel controlPanel) {
        NullCheck.notNull((Object)controlPanel, (String)"controlPanel");
        Luwrain luwrain = controlPanel.getCoreInterface();
        return new Speech(controlPanel, luwrain.i18n().getStaticStr("CpSpeechGeneral"));
    }
}

