/*
 * Decompiled with CFR 0.152.
 */
package org.luwrain.settings;

import java.util.Objects;
import org.luwrain.core.Luwrain;
import org.luwrain.cpanel.Element;
import org.luwrain.cpanel.Factory;
import org.luwrain.cpanel.Section;
import org.luwrain.cpanel.SimpleElement;
import org.luwrain.cpanel.SimpleSection;
import org.luwrain.cpanel.StandardElements;
import org.luwrain.settings.Braille;
import org.luwrain.settings.DateTime;
import org.luwrain.settings.FileTypes;
import org.luwrain.settings.HardwareCpuMem;
import org.luwrain.settings.HotKeys;
import org.luwrain.settings.MainMenu;
import org.luwrain.settings.PersonalInfo;
import org.luwrain.settings.SoundSchemes;
import org.luwrain.settings.SoundsList;
import org.luwrain.settings.Speech;
import org.luwrain.settings.UserInterface;
import org.luwrain.settings.Version;

public final class StandardFactory
implements Factory {
    private static final String ELEMENT_PREFIX = StandardFactory.class.getName() + ".";
    private static final Element personalInfo = new SimpleElement(StandardElements.ROOT, ELEMENT_PREFIX + "PersonalInfo");
    private static final Element uiGeneral = new SimpleElement(StandardElements.UI, ELEMENT_PREFIX + "UIGeneral");
    private static final Element hotKeys = new SimpleElement(StandardElements.UI, ELEMENT_PREFIX + "HotKeys");
    private static final Element fileTypes = new SimpleElement(StandardElements.UI, ELEMENT_PREFIX + "FileTypes");
    private static final Element mainMenu = new SimpleElement(StandardElements.UI, ELEMENT_PREFIX + "MainMenu");
    private static final Element hardwareCpuMem = new SimpleElement(StandardElements.HARDWARE, ELEMENT_PREFIX + "HardwareCpuMem");
    private static final Element hardwareSysDevices = new SimpleElement(StandardElements.HARDWARE, ELEMENT_PREFIX + "HardwareSysDevices");
    private static final Element version = new SimpleElement(StandardElements.ROOT, ELEMENT_PREFIX + "Version");
    private static final Element dateTime = new SimpleElement(StandardElements.ROOT, ELEMENT_PREFIX + "DateTime");
    private static final Element speechGeneral = new SimpleElement(StandardElements.SPEECH, ELEMENT_PREFIX + "SpeechCurrent");
    private static final Element soundsList = new SimpleElement(StandardElements.UI, ELEMENT_PREFIX + "SoundsList");
    private static final Element soundSchemes = new SimpleElement(StandardElements.UI, ELEMENT_PREFIX + "SoundSchemes");
    private final Luwrain luwrain;

    public StandardFactory(Luwrain luwrain) {
        this.luwrain = Objects.requireNonNull(luwrain, "luwrain can't be null");
    }

    @Override
    public Element[] getElements() {
        return new Element[]{version, StandardElements.ROOT, personalInfo, StandardElements.APPLICATIONS, StandardElements.UI, uiGeneral, hotKeys, mainMenu, soundsList, fileTypes, StandardElements.INPUT_OUTPUT, StandardElements.SPEECH, StandardElements.SOUND, StandardElements.KEYBOARD, StandardElements.HARDWARE, hardwareCpuMem, hardwareSysDevices, StandardElements.NETWORK, dateTime, StandardElements.EXTENSIONS, StandardElements.WORKERS, speechGeneral};
    }

    @Override
    public Element[] getOnDemandElements(Element parent) {
        Objects.requireNonNull(parent, "parent can't be null");
        return new Element[0];
    }

    @Override
    public Section createSection(Element el) {
        Objects.requireNonNull(el, "el can't be null");
        if (el.equals(hardwareSysDevices)) {
            return new SimpleSection(hardwareSysDevices, this.luwrain.getString("STATIC:CpSysDevices"));
        }
        if (el.equals(StandardElements.ROOT)) {
            return new SimpleSection(StandardElements.ROOT, this.luwrain.getString("STATIC:CpTreeRoot"));
        }
        if (el.equals(StandardElements.APPLICATIONS)) {
            return new SimpleSection(StandardElements.APPLICATIONS, this.luwrain.getString("STATIC:CpApplications"));
        }
        if (el.equals(dateTime)) {
            return new SimpleSection(dateTime, this.luwrain.getString("STATIC:CpDateTime"), controlPanel -> new DateTime(controlPanel));
        }
        if (el.equals(StandardElements.INPUT_OUTPUT)) {
            return new SimpleSection(StandardElements.INPUT_OUTPUT, this.luwrain.getString("STATIC:CpInputOutput"));
        }
        if (el.equals(StandardElements.KEYBOARD)) {
            return new SimpleSection(StandardElements.KEYBOARD, this.luwrain.getString("STATIC:CpKeyboard"));
        }
        if (el.equals(StandardElements.SOUND)) {
            return new SimpleSection(StandardElements.SOUND, this.luwrain.getString("STATIC:CpSound"));
        }
        if (el.equals(StandardElements.BRAILLE)) {
            return new SimpleSection(StandardElements.BRAILLE, "\u0411\u0440\u0430\u0438\u043b\u044c", controlPanel -> Braille.create(controlPanel));
        }
        if (el.equals(StandardElements.SPEECH)) {
            return new SimpleSection(StandardElements.SPEECH, this.luwrain.getString("STATIC:CpSpeech"));
        }
        if (el.equals(StandardElements.NETWORK)) {
            return new SimpleSection(StandardElements.NETWORK, this.luwrain.getString("STATIC:CpNetwork"));
        }
        if (el.equals(StandardElements.HARDWARE)) {
            return new SimpleSection(StandardElements.HARDWARE, this.luwrain.getString("STATIC:CpHardware"));
        }
        if (el.equals(StandardElements.UI)) {
            return new SimpleSection(StandardElements.UI, this.luwrain.getString("STATIC:CpUserInterface"));
        }
        if (el.equals(StandardElements.EXTENSIONS)) {
            return new SimpleSection(StandardElements.EXTENSIONS, this.luwrain.getString("STATIC:CpExtensions"));
        }
        if (el.equals(StandardElements.WORKERS)) {
            return new SimpleSection(StandardElements.WORKERS, this.luwrain.getString("STATIC:CpBackgroundWorkers"));
        }
        if (el.equals(uiGeneral)) {
            return new SimpleSection(uiGeneral, this.luwrain.getString("STATIC:CpUiGeneral"), controlPanel -> UserInterface.create(controlPanel));
        }
        if (el.equals(hotKeys)) {
            return new SimpleSection(hotKeys, this.luwrain.getString("STATIC:CpHotKeys"), controlPanel -> HotKeys.create(controlPanel));
        }
        if (el.equals(personalInfo)) {
            return new SimpleSection(personalInfo, this.luwrain.getString("STATIC:CpPersonalInfoSection"), controlPanel -> new PersonalInfo(controlPanel));
        }
        if (el.equals(fileTypes)) {
            return new SimpleSection(fileTypes, this.luwrain.getString("STATIC:CpFileTypes"), controlPanel -> FileTypes.create(controlPanel));
        }
        if (el.equals(hardwareCpuMem)) {
            return new SimpleSection(hardwareCpuMem, this.luwrain.getString("STATIC:CpCpuAndMem"), controlPanel -> HardwareCpuMem.create(controlPanel));
        }
        if (el.equals(version)) {
            return new SimpleSection(version, this.luwrain.getString("STATIC:CpVersion"), controlPanel -> Version.create(controlPanel));
        }
        if (el.equals(speechGeneral)) {
            return new SimpleSection(speechGeneral, this.luwrain.getString("STATIC:CpSpeechGeneral"), controlPanel -> Speech.create(controlPanel));
        }
        if (el.equals(soundsList)) {
            return new SimpleSection(soundsList, this.luwrain.getString("STATIC:CpSoundsList"), controlPanel -> SoundsList.create(controlPanel));
        }
        if (el.equals(mainMenu)) {
            return new SimpleSection(mainMenu, this.luwrain.getString("STATIC:CpMainMenu"), controlPanel -> MainMenu.create(controlPanel));
        }
        if (el.equals(soundSchemes)) {
            return new SimpleSection(soundSchemes, "\u0417\u0432\u0443\u043a\u043e\u0432\u044b\u0435 \u0441\u0445\u0435\u043c\u044b", controlPanel -> SoundSchemes.create(controlPanel));
        }
        return null;
    }
}

